/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.feignAPI;

import com.elitescloud.boot.CloudtSpringContextHolder;
import com.elitescloud.boot.swagger.feignAPI.DocumentedFeignApi;
import com.elitescloud.boot.swagger.openapi.common.spi.OpenApiLoadStrategySPI;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenFeignApiServiceUtil;
import com.elitescloud.boot.util.JSONUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class OpenApiLoadStrategyRpc
implements OpenApiLoadStrategySPI {
    @Override
    public List<Class<?>> load() {
        ApplicationContext applicationContext = CloudtSpringContextHolder.getApplicationContext();
        Map beansWithAnnotation = applicationContext.getBeansWithAnnotation(DocumentedFeignApi.class);
        ArrayList classes = new ArrayList();
        beansWithAnnotation.forEach((name, bean) -> {
            Class<?>[] interfaces;
            for (Class<?> iface : interfaces = bean.getClass().getInterfaces()) {
                if (!iface.isAnnotationPresent(DocumentedFeignApi.class)) continue;
                classes.add(iface);
            }
        });
        return classes;
    }

    @Override
    public List<OpenApiLoadStrategySPI.OpenApiInfo> analyze(Class<?> clazz) {
        FeignClient requestMapping = clazz.getAnnotation(FeignClient.class);
        if (requestMapping == null) {
            return new ArrayList<OpenApiLoadStrategySPI.OpenApiInfo>();
        }
        String basePath = requestMapping.path();
        DocumentedFeignApi documentedFeignApi = clazz.getAnnotation(DocumentedFeignApi.class);
        ArrayList<OpenApiLoadStrategySPI.OpenApiInfo> openApiInfos = new ArrayList<OpenApiLoadStrategySPI.OpenApiInfo>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!OpenFeignApiServiceUtil.isAnnotationMapping(method).booleanValue()) continue;
            DocumentedFeignApi methodAnnotation = method.getAnnotation(DocumentedFeignApi.class);
            String methodPath = OpenFeignApiServiceUtil.getMethodPath(method);
            OpenApiLoadStrategySPI.OpenApiInfo openApiInfo = new OpenApiLoadStrategySPI.OpenApiInfo(method, OpenApiLoadStrategyRpc.getOperationBasedOnHttpMethod(method), basePath + methodPath);
            openApiInfo.setApiType(2);
            openApiInfo.setOperationGroup(documentedFeignApi.description());
            openApiInfo.setDetail(methodAnnotation != null ? methodAnnotation.description() : "");
            openApiInfo.setOperationDescription(clazz.getName() + "-" + method.getName());
            String returnTypeJson = JSONUtil.toJsonString((Object)method.getGenericReturnType().getTypeName());
            openApiInfo.setReturnTypeJson(returnTypeJson);
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (Type parameterType : method.getGenericParameterTypes()) {
                parameterTypes.add(parameterType.getTypeName());
            }
            String parameterTypesJson = JSONUtil.toJsonString(parameterTypes);
            openApiInfo.setParameterTypesJson(parameterTypesJson);
            openApiInfos.add(openApiInfo);
        }
        return openApiInfos;
    }

    private static RequestMethod getOperationBasedOnHttpMethod(Method method) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            return RequestMethod.GET;
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return RequestMethod.POST;
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return RequestMethod.PUT;
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return RequestMethod.DELETE;
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return RequestMethod.PATCH;
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            RequestMethod[] methods = requestMapping.method();
            if (methods.length > 0) {
                RequestMethod methodMapping = methods[0];
                switch (methodMapping) {
                    case GET: {
                        return RequestMethod.GET;
                    }
                    case POST: {
                        return RequestMethod.POST;
                    }
                    case PUT: {
                        return RequestMethod.PUT;
                    }
                    case DELETE: {
                        return RequestMethod.DELETE;
                    }
                    case PATCH: {
                        return RequestMethod.PATCH;
                    }
                    case HEAD: {
                        return RequestMethod.HEAD;
                    }
                    case TRACE: {
                        return RequestMethod.TRACE;
                    }
                    case OPTIONS: {
                        return RequestMethod.OPTIONS;
                    }
                }
                throw new RuntimeException("\u672a\u627e\u5230RequestMapping\u6ce8\u89e3" + methodMapping);
            }
            throw new RuntimeException("\u672a\u627e\u5230RequestMapping\u6ce8\u89e3methodMapping");
        }
        throw new RuntimeException("\u672a\u627e\u5230HTTP\u6ce8\u89e3");
    }

    @Override
    public boolean isRequestBody(Parameter parameter) {
        return false;
    }
}

