package com.elitescloud.boot.swagger;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.swagger.openapi.client.OpenApiRpcProvider;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.config.OpenApiSwaggerConfig;
import com.elitescloud.boot.swagger.openapi.contrlloer.OpenApiController;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

/**
 * Swagger自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/14/2023
 */
@Slf4j
@ConditionalOnProperty(prefix = OpenApiProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties({OpenApiProperties.class})
@Import(OpenApiSwaggerConfig.class)
class CloudtOpenApiAutoConfiguration {

    @Value("${spring.application.name:#{''}}")
    private String applicationName;

    @Bean
    public OpenApiService openApiService(ApplicationContext applicationContext,
                                         OpenApiProperties openApiProperties) {
        if (CharSequenceUtil.isBlank(openApiProperties.getService())) {
            openApiProperties.setService(applicationName);
            openApiProperties.setServiceName(applicationName);
        }
        return new OpenApiService(applicationContext, openApiProperties);
    }

    @Bean
    public OpenApiController openApiController(OpenApiService openApiService) {
        return new OpenApiController(openApiService);
    }

    @Bean
    public OpenApiRpcProvider openApiRpcClient(OpenApiService openApiService) {
        return new OpenApiRpcProvider(openApiService);
    }
}
