package com.elitescloud.boot.swagger.feignapi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author : chen.niu
 * @description :
 * Feign接口的注解
 * 允许注解在类和方法上,
 * 如果是类上，则表示下面方法接口再数据采集的时候的分组归属描述。
 * 如果是方法上，标识对方法接口的描述
 * @date : 2024-07-16 13:16
 */
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface DocumentedFeignApi {
    String description() default "";// 可以用来描述API的名称或描述
//    String[] tags() default {}; // API的标签，用于分类或搜索


}