package com.elitescloud.boot.swagger.openapi.service.impl;

import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * @author : chen.niu
 * @description : openApi规范的对象封装，结合业务对象扩展
 * @date : 2024-01-02 15:00
 */
@Slf4j
public class OpenApiService {

    private final ApplicationContext applicationContext;

    private final OpenApiProperties openApiProperties;


    public OpenApiService(ApplicationContext applicationContext, OpenApiProperties openApiProperties) {
        this.applicationContext = applicationContext;
        this.openApiProperties = openApiProperties;

    }

    /**
     * 主方法 生成 OpenAPI 对象，包含所有使用 @RestController 注解的类的 API 信息。
     */
    public OpenAPI generateOpenApi() {
        OpenAPI openApi = new OpenAPI();
        OpenApiServiceUtil.setInitInfo(openApi, openApiProperties);

        // 使用循环生成参数对象并添加到Components
        Map<String, Object> controllers = applicationContext.getBeansWithAnnotation(RestController.class);
        for (Object controller : controllers.values()) {
            this.processController(openApi, controller);
        }

        // SPI调用 用于controller之外的数据采集扩展
        OpenApiServiceUtil.processBySpi(openApi);
        return openApi;
    }

    /**
     * 对单个controller生成openApi对象
     * <p>
     * 用于测试
     *
     * @param controllers controller对象列表
     * @return
     */
    public OpenAPI generateOpenApi(Object... controllers) {
        OpenAPI openApi = new OpenAPI();
        OpenApiServiceUtil.setInitInfo(openApi, openApiProperties);

        if (controllers != null) {
            for (Object controller : controllers) {
                this.processController(openApi, controller);
            }
        }

        // SPI调用
        OpenApiServiceUtil.processBySpi(openApi);

        return openApi;
    }

    public Info getOpenApiInfo() {
        return OpenApiServiceUtil.getInfo(openApiProperties);
    }

    private void processController(OpenAPI openApi, Object controller) {
        Class<?> controllerClass = AopProxyUtils.ultimateTargetClass(controller);
        OpenApiServiceUtil.processController(controllerClass, openApi, openApi.getPaths());
    }
}
