/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.common.annotation.BusinessObjectOperation;
import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.boot.swagger.openapi.common.spi.OpenApiLoadStrategySPI;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectInfo;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectOperationInfo;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectParamInfo;
import com.elitescloud.boot.swagger.openapi.swagger3.annotations.enums.ParameterIn;
import com.elitescloud.boot.swagger.openapi.swagger3.core.converter.ModelConverters;
import com.elitescloud.boot.swagger.openapi.swagger3.core.converter.ResolvedSchema;
import com.elitescloud.boot.swagger.openapi.swagger3.core.util.PrimitiveType;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Components;
import com.elitescloud.boot.swagger.openapi.swagger3.models.OpenAPI;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Operation;
import com.elitescloud.boot.swagger.openapi.swagger3.models.PathItem;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Paths;
import com.elitescloud.boot.swagger.openapi.swagger3.models.info.Info;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.ArraySchema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Content;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MapSchema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MediaType;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Schema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.StringSchema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.HeaderParameter;
import com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponse;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponses;
import com.elitescloud.boot.swagger.openapi.swagger3.models.tags.Tag;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class OpenFeignApiServiceUtil {
    private static final Logger logger = CloudtBootLoggerFactory.SWAGGER.getLogger(OpenFeignApiServiceUtil.class);
    public static final String X_PROJECT = "x-Project";
    public static final String X_PROJECT_NAME = "x-Project-Name";
    public static final String X_ENV = "x-Env";
    public static final String X_ENV_NAME = "x-Env-Name";
    public static final String X_SERVICE = "x-Service";
    public static final String X_SERVICE_NAME = "x-Service-Name";
    public static final String X_BUSINESS_OBJECTS = "x-BusinessObjects";
    public static final String X_BUSINESS_OBJECT = "x-BusinessObject";
    public static final String X_BUSINESS_OBJECT_OPERATION = "x-BusinessObject-Operation";
    public static final String X_OPEN_API_PROPERTIES = "x-OpenApiProperties";
    public static final String X_PROJECT_VERSION = "x-ProjectVersion";
    public static final String X_CLOUDT_BOOT_VERSION = "x-CloudtBootVersion";
    public static final String X_NEW_DATE = "x-BuildTime";
    public static final String DEFAULT_TAG = "\u516c\u5171\u63a5\u53e3";
    private static final List<Parameter> commonHeaders = new ArrayList<Parameter>();
    private static final Map<Class<?>, BusinessObjectParamInfo> PARAM_INFO_MAP = new HashMap(128);
    private static final List<OpenApiLoadStrategySPI> spiList = new ArrayList<OpenApiLoadStrategySPI>(4);
    private static final ModelConverters modelConverters = ModelConverters.getInstance();

    public static void processOperation(Operation operation) {
        if (operation != null) {
            commonHeaders.forEach(operation::addParametersItem);
        }
    }

    public static void setInitInfo(OpenAPI openAPI, OpenApiProperties openApiProperties) {
        Paths paths = new Paths();
        Tag tag = new Tag().name(DEFAULT_TAG).description("\u672a\u4e1a\u52a1\u5bf9\u8c61\u6ce8\u89e3\u8fdb\u884c\u5206\u7ec4\u7684\u63a5\u53e3\uff0c\u516c\u5171\u63a5\u53e3\u6ca1\u6709\u5177\u4f53\u4e1a\u52a1\u5bf9\u8c61\u3002");
        openAPI.addTagsItem(tag);
        for (OperationStateEnum state : OperationStateEnum.values()) {
            openAPI.addTagsItem(new Tag().name(state.getDescription()).description(state.name()));
        }
        Info info = OpenFeignApiServiceUtil.getInfo(openApiProperties);
        openAPI.setInfo(info);
        openAPI.setComponents(new Components());
        openAPI.setPaths(paths);
    }

    public static Info getInfo(OpenApiProperties openApiProperties) {
        StringBuffer titleBuffer = new StringBuffer();
        titleBuffer.append(openApiProperties.getProject()).append(":").append(openApiProperties.getProjectName()).append(":").append(openApiProperties.getEnv()).append(":").append(openApiProperties.getEnvName()).append(":").append(openApiProperties.getService()).append(":").append(openApiProperties.getServiceName());
        Info info = new Info().title(titleBuffer.toString()).description(openApiProperties.getDescription());
        info.addExtension(X_NEW_DATE, DatetimeUtil.currentTimeStr());
        info.setVersion(openApiProperties.getProjectVersion());
        info.setSummary(openApiProperties.getCloudtBootVersion());
        info.addExtension(X_PROJECT, openApiProperties.getProject());
        info.addExtension(X_PROJECT_NAME, openApiProperties.getProjectName());
        info.addExtension(X_ENV, openApiProperties.getEnv());
        info.addExtension(X_ENV_NAME, openApiProperties.getEnvName());
        info.addExtension(X_SERVICE, openApiProperties.getService());
        info.addExtension(X_SERVICE_NAME, openApiProperties.getServiceName());
        info.addExtension(X_PROJECT_VERSION, openApiProperties.getProjectVersion());
        info.addExtension(X_CLOUDT_BOOT_VERSION, openApiProperties.getCloudtBootVersion());
        info.addExtension(X_CLOUDT_BOOT_VERSION, openApiProperties.getCloudtBootVersion());
        return info;
    }

    public static void processOpenFeignController(Class<?> controllerClass, OpenAPI openAPI, Paths paths) {
        FeignClient requestMapping = controllerClass.getAnnotation(FeignClient.class);
        if (requestMapping == null) {
            throw new RuntimeException(controllerClass.getName() + "\u6ca1\u6709\u627e\u5230@FeignClient\u6ce8\u89e3\uff0c\u6216\u4e0d\u662fopenfeign\u63a5\u53e3");
        }
        String basePath = requestMapping == null ? "\u672a\u91c7\u96c6" : requestMapping.path();
        DocumentedFeignApi documentedFeignApi = controllerClass.getAnnotation(DocumentedFeignApi.class);
        openAPI.addTagsItem(new Tag().name(documentedFeignApi.description()));
        for (Method method : controllerClass.getDeclaredMethods()) {
            if (!OpenFeignApiServiceUtil.isAnnotationMapping(method).booleanValue()) continue;
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            Operation operation = new Operation();
            operation.setSummary(apiOperation == null ? method.getName() : (StringUtils.isBlank((CharSequence)apiOperation.value()) ? "\u7a7a" : apiOperation.value()));
            operation.setDescription(apiOperation == null ? method.getName() : (StringUtils.isBlank((CharSequence)apiOperation.notes()) ? "\u7a7a" : apiOperation.notes()));
            operation.setDeprecated(method.isAnnotationPresent(Deprecated.class));
            operation.operationId(method.toString());
            operation.addTagsItem(documentedFeignApi.description());
            Type returnType = method.getGenericReturnType();
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(returnType);
            Schema mehtodReturnSchema = OpenFeignApiServiceUtil.processMehtodRetuntComponentsGetSchema(openAPI, resolvedSchema);
            for (java.lang.reflect.Parameter parameter : method.getParameters()) {
                Parameter parameterV3;
                RequestBody requestBodyAnnotation = parameter.getAnnotation(RequestBody.class);
                if (requestBodyAnnotation != null) {
                    OpenFeignApiServiceUtil.processRequestBody(parameter, operation, openAPI);
                }
                if ((parameterV3 = OpenFeignApiServiceUtil.createParameterForApi(parameter)) == null) continue;
                operation.addParametersItem(parameterV3);
            }
            OpenFeignApiServiceUtil.processReturnParameter(operation, mehtodReturnSchema);
            String path = basePath + OpenFeignApiServiceUtil.getMethodPath(method);
            OpenFeignApiServiceUtil.addOperationToPathItem(path, method, operation, paths);
        }
    }

    public static void analyzeOpenApi(@NotNull OpenAPI openAPI, @NotNull Class<?> clazz) {
        List<OpenApiLoadStrategySPI> spiList = OpenFeignApiServiceUtil.loadSpiList();
        if (spiList.isEmpty()) {
            return;
        }
        for (OpenApiLoadStrategySPI spi : spiList) {
            List<OpenApiLoadStrategySPI.OpenApiInfo> openApiList;
            if (!spi.enabled() || !spi.support(clazz) || CollUtil.isEmpty(openApiList = spi.analyze(clazz))) continue;
            for (OpenApiLoadStrategySPI.OpenApiInfo openApiInfo : openApiList) {
                OpenFeignApiServiceUtil.process(openAPI, openApiInfo, spi);
            }
        }
    }

    private static void process(OpenAPI openAPI, OpenApiLoadStrategySPI.OpenApiInfo openApiInfo, OpenApiLoadStrategySPI spi) {
        if (OpenFeignApiServiceUtil.onlyGatherBusinessOperation() && openApiInfo.getBusinessObjectOperation() == null) {
            return;
        }
        Assert.notNull((Object)openApiInfo.getMethod(), (String)"method\u4e3a\u7a7a");
        Assert.notNull((Object)openApiInfo.getUri(), (String)"uri\u4e3a\u7a7a");
        Operation operation = OpenFeignApiServiceUtil.createOperation(openAPI, openApiInfo);
        for (java.lang.reflect.Parameter parameter : openApiInfo.getMethod().getParameters()) {
            if (spi.isRequestBody(parameter)) {
                OpenFeignApiServiceUtil.processRequestBody(parameter, operation, openAPI);
                continue;
            }
            Parameter paramApi = OpenFeignApiServiceUtil.createParameterForApi(parameter);
            if (paramApi == null) continue;
            operation.addParametersItem(paramApi);
        }
        Type returnType = openApiInfo.getMethod().getGenericReturnType();
        ResolvedSchema resolvedSchema = modelConverters.readAllAsResolvedSchema(returnType);
        Schema mehtodReturnSchema = OpenFeignApiServiceUtil.processMehtodRetuntComponentsGetSchema(openAPI, resolvedSchema);
        OpenFeignApiServiceUtil.processReturnParameter(operation, mehtodReturnSchema);
        OpenFeignApiServiceUtil.addOperationToPathItem(openApiInfo.getUri(), openApiInfo.getRequestMethod(), operation, openAPI.getPaths());
    }

    public static Schema processMehtodRetuntComponentsGetSchema(OpenAPI openAPI, ResolvedSchema resolvedSchema) {
        Schema mehtodReturnSchemaNew = null;
        if (resolvedSchema != null && resolvedSchema.schema != null) {
            mehtodReturnSchemaNew = resolvedSchema.schema;
        }
        if (resolvedSchema != null && resolvedSchema.referencedSchemas != null && resolvedSchema.referencedSchemas.size() > 0) {
            for (Map.Entry<String, Schema> entry : resolvedSchema.referencedSchemas.entrySet()) {
                String name = entry.getKey();
                Schema schema = entry.getValue();
                openAPI.getComponents().addSchemas(name, schema);
                if (mehtodReturnSchemaNew != null) continue;
                mehtodReturnSchemaNew = schema;
            }
        }
        return mehtodReturnSchemaNew;
    }

    private static boolean onlyGatherBusinessOperation() {
        return true;
    }

    private static void processReturnParameter(Operation operation, Schema mehtodReturnSchema) {
        ApiResponse apiResponse = new ApiResponse();
        apiResponse.content(new Content().addMediaType("application/json", new MediaType().schema(mehtodReturnSchema)));
        ApiResponses apiResponses = new ApiResponses();
        apiResponses.addApiResponse("200", apiResponse);
        operation.setResponses(apiResponses);
    }

    private static Operation createOperationFromApiOperation(OpenAPI openAPI, BusinessObject businessObject, Method method) {
        BusinessObjectOperation businessObjectOperation;
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        Operation operation = new Operation();
        operation.setSummary(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.value()) ? "\u7a7a" : apiOperation.value()));
        operation.setDescription(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.notes()) ? "\u7a7a" : apiOperation.notes()));
        operation.setDeprecated(method.isAnnotationPresent(Deprecated.class));
        operation.operationId(method.toString());
        if (businessObject != null) {
            OpenFeignApiServiceUtil.buildBusinessObjectInfo(openAPI, businessObject);
            openAPI.addTagsItem(new Tag().name(businessObject.businessType()));
        }
        if ((businessObjectOperation = method.getAnnotation(BusinessObjectOperation.class)) != null) {
            String businessObjectCode;
            Object object = "@BusinessObject".equals(businessObjectOperation.businessObjectType()) ? (businessObject == null ? null : businessObject.businessType()) : (businessObjectCode = businessObjectOperation.businessObjectType());
            if (CharSequenceUtil.isBlank((CharSequence)businessObjectCode)) {
                return null;
            }
            Assert.hasText((String)businessObjectCode, () -> method.getDeclaringClass().getName() + "." + method.getName() + "()\u64cd\u4f5c\u672a\u660e\u786e\u6240\u5c5e\u4e1a\u52a1\u5bf9\u8c61");
            operation.addTagsItem(businessObjectCode);
            BusinessObjectOperationInfo businessObjectOperationInfo = BusinessObjectOperationInfo.getBusinessObjectOperationInfo(businessObjectOperation);
            businessObjectOperationInfo.setBusinessObjectType(businessObjectCode);
            operation.addExtension(X_BUSINESS_OBJECT_OPERATION, businessObjectOperationInfo);
            operation.setSummary(operation.getSummary() + "-" + businessObjectOperationInfo.getOperationStateEnum().getDescription());
            operation.addTagsItem(businessObjectOperationInfo.getOperationStateEnum().getDescription());
            operation.addTagsItem(businessObjectOperationInfo.getOperationScopeEnum().getDescription());
        }
        openAPI.addTagsItem(new Tag().name("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + ";\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary()));
        operation.addTagsItem("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + ";\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary());
        return operation;
    }

    public static Class<?> getGenericTypeClass(Type type) {
        Type firstTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length > 0 && (firstTypeArgument = actualTypeArguments[0]) instanceof Class) {
            return (Class)firstTypeArgument;
        }
        return null;
    }

    public static Parameter createParameterForApi(java.lang.reflect.Parameter parameter) {
        Parameter parameterV3 = new Parameter();
        String annotationParameterType = OpenFeignApiServiceUtil.getAnnotationParameterType(parameter);
        if (annotationParameterType == null) {
            return null;
        }
        ResolvedSchema schemaResolved = ModelConverters.getInstance().readAllAsResolvedSchema(parameter.getParameterizedType());
        PrimitiveType pType = PrimitiveType.fromType(parameter.getParameterizedType());
        Schema schema = new Schema();
        if (schemaResolved == null) {
            schema.setName(pType.getCommonName());
            schema.setTitle(pType.name());
            schema.setType(pType.name());
            schema = pType.createProperty();
        } else {
            schema = schemaResolved.schema;
        }
        parameterV3.setName(parameter.getName());
        parameterV3.setSchema(schema);
        parameterV3.setDescription(parameter.getName());
        parameterV3.setRequired(true);
        parameterV3.setIn(annotationParameterType);
        return parameterV3;
    }

    public static String getAnnotationParameterType(java.lang.reflect.Parameter parameter) {
        if (parameter.isAnnotationPresent(PathVariable.class)) {
            return ParameterIn.PATH.toString();
        }
        if (parameter.isAnnotationPresent(RequestParam.class)) {
            return ParameterIn.QUERY.toString();
        }
        if (parameter.isAnnotationPresent(RequestHeader.class)) {
            return ParameterIn.HEADER.toString();
        }
        if (parameter.isAnnotationPresent(CookieValue.class)) {
            return ParameterIn.COOKIE.toString();
        }
        return null;
    }

    public static List<BusinessObjectParamInfo> obtainBusinessObjectParamInfoList(Class<?> ... entityClasses) {
        if (ArrayUtil.isEmpty((Object[])entityClasses)) {
            return Collections.emptyList();
        }
        ArrayList<BusinessObjectParamInfo> paramInfoList = new ArrayList<BusinessObjectParamInfo>(entityClasses.length);
        HashSet<String> entityClassNames = new HashSet<String>(entityClasses.length);
        for (Class<?> entityClass : entityClasses) {
            if (entityClass == null || entityClass == Void.class || entityClassNames.contains(entityClass.getName())) continue;
            entityClassNames.add(entityClass.getName());
            BusinessObjectParamInfo paramInfo = PARAM_INFO_MAP.computeIfAbsent(entityClass, cls -> {
                BusinessObjectParamInfo info = new BusinessObjectParamInfo();
                info.setClassName(cls.getName());
                info.setTableName(OpenFeignApiServiceUtil.obtainTableName(cls));
                info.setTableComment(OpenFeignApiServiceUtil.obtainTableComment(cls));
                info.setParamList(OpenFeignApiServiceUtil.obtainEntityFields(cls));
                return info;
            });
            paramInfoList.add(paramInfo);
        }
        return paramInfoList;
    }

    private static void addOperationToPathItem(String path, Method method, Operation operation, Paths paths) {
        PathItem pathItem = (PathItem)paths.get(path);
        if (pathItem == null) {
            pathItem = new PathItem();
        }
        OpenFeignApiServiceUtil.setOperationBasedOnHttpMethod(method, pathItem, operation);
        paths.addPathItem(path, pathItem);
    }

    private static void addOperationToPathItem(String path, RequestMethod requestMethod, Operation operation, Paths paths) {
        PathItem pathItem = (PathItem)paths.get(path);
        if (pathItem == null) {
            pathItem = new PathItem();
        }
        OpenFeignApiServiceUtil.setOperationBasedOnHttpMethod(requestMethod, pathItem, operation);
        paths.addPathItem(path, pathItem);
    }

    public static String getMethodPath(Method method) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        PatchMapping patchMapping = method.getAnnotation(PatchMapping.class);
        if (patchMapping != null && patchMapping.value().length > 0) {
            return patchMapping.value()[0];
        }
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        if (requestMapping != null && requestMapping.value().length > 0) {
            return requestMapping.value()[0];
        }
        return "";
    }

    private static String generateHash(String methodName) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(methodName.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found", e);
        }
    }

    private static void setOperationBasedOnHttpMethod(Method method, PathItem pathItem, Operation operation) {
        RequestMapping requestMapping;
        RequestMethod[] methods;
        if (method.isAnnotationPresent(GetMapping.class)) {
            pathItem.setGet(operation);
        } else if (method.isAnnotationPresent(PostMapping.class)) {
            pathItem.setPost(operation);
        } else if (method.isAnnotationPresent(PutMapping.class)) {
            pathItem.setPut(operation);
        } else if (method.isAnnotationPresent(DeleteMapping.class)) {
            pathItem.setDelete(operation);
        } else if (method.isAnnotationPresent(PatchMapping.class)) {
            pathItem.setPatch(operation);
        } else if (method.isAnnotationPresent(RequestMapping.class) && (methods = (requestMapping = method.getAnnotation(RequestMapping.class)).method()).length > 0) {
            RequestMethod methodMapping = methods[0];
            switch (methodMapping) {
                case GET: {
                    pathItem.setGet(operation);
                    break;
                }
                case POST: {
                    pathItem.setPost(operation);
                    break;
                }
                case PUT: {
                    pathItem.setPut(operation);
                    break;
                }
                case DELETE: {
                    pathItem.setDelete(operation);
                    break;
                }
                case PATCH: {
                    pathItem.setPatch(operation);
                    break;
                }
                case HEAD: {
                    pathItem.setHead(operation);
                    break;
                }
                case TRACE: {
                    pathItem.setHead(operation);
                    break;
                }
                case OPTIONS: {
                    pathItem.setOptions(operation);
                    break;
                }
            }
        }
        OpenFeignApiServiceUtil.processOperation(operation);
    }

    private static void setOperationBasedOnHttpMethod(RequestMethod requestMethod, PathItem pathItem, Operation operation) {
        switch (requestMethod) {
            case GET: {
                pathItem.setGet(operation);
                break;
            }
            case POST: {
                pathItem.setPost(operation);
                break;
            }
            case PUT: {
                pathItem.setPut(operation);
                break;
            }
            case PATCH: {
                pathItem.setPatch(operation);
                break;
            }
            case DELETE: {
                pathItem.setDelete(operation);
            }
        }
        OpenFeignApiServiceUtil.processOperation(operation);
    }

    public static Boolean isAnnotationMapping(Method method) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            return true;
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return true;
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return true;
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return true;
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return true;
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            return true;
        }
        return false;
    }

    private static void processRequestBody(java.lang.reflect.Parameter parameter, Operation operation, OpenAPI openAPI) {
        Schema returnSchema;
        Class<?> paramType = parameter.getType();
        if (paramType.isArray() || Collection.class.isAssignableFrom(paramType)) {
            Type parameterizedType = parameter.getParameterizedType();
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(parameterizedType);
            if (resolvedSchema == null) {
                return;
            }
            Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
            Schema schema = schemaMap.get(OpenFeignApiServiceUtil.getGenericTypeClass(parameterizedType).getSimpleName());
            returnSchema = new ArraySchema().name(paramType.getName()).items(schema).description(parameter.getParameterizedType().getTypeName());
            for (Map.Entry entry : schemaMap.entrySet()) {
                String name = (String)entry.getKey();
                Schema schema2 = (Schema)entry.getValue();
                openAPI.getComponents().addSchemas(name, schema2);
            }
        } else if (Map.class.isAssignableFrom(paramType)) {
            returnSchema = new MapSchema();
            returnSchema.setAdditionalProperties(true);
            returnSchema.description(parameter.getParameterizedType().getTypeName());
            returnSchema.name(paramType.getSimpleName());
        } else {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().readAllAsResolvedSchema(paramType);
            if (resolvedSchema == null) {
                return;
            }
            Map<String, Schema> schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap == null) {
                return;
            }
            if (parameter.getParameterizedType() instanceof ParameterizedType) {
                logger.error("\u4e0d\u662f\u6570\u7ec4\u6709\u6cdb\u578b");
            }
            returnSchema = schemaMap.get(paramType.getSimpleName());
            for (Map.Entry entry : schemaMap.entrySet()) {
                String name = (String)entry.getKey();
                Schema schema = (Schema)entry.getValue();
                openAPI.getComponents().addSchemas(name, schema);
            }
        }
        com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.RequestBody requestBody = new com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.RequestBody();
        MediaType mediaType = new MediaType();
        Content content = new Content();
        content.addMediaType("application/json", mediaType.schema(returnSchema));
        requestBody.content(content);
        operation.setRequestBody(requestBody);
    }

    private static Operation createOperation(OpenAPI openAPI, OpenApiLoadStrategySPI.OpenApiInfo openApiInfo) {
        Method method = openApiInfo.getMethod();
        ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
        Operation operation = new Operation();
        operation.setSummary(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.value()) ? "\u7a7a" : apiOperation.value()));
        operation.setDescription(apiOperation == null ? "\u7a7a" : (StringUtils.isBlank((CharSequence)apiOperation.notes()) ? "\u7a7a" : apiOperation.notes()));
        operation.setDeprecated(method.isAnnotationPresent(Deprecated.class));
        operation.operationId(method.toString());
        openAPI.addTagsItem(new Tag().name("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + ";\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary()));
        operation.addTagsItem("\u5de5\u7a0b\u7248\u672c" + openAPI.getInfo().getVersion() + ";\u67b6\u6784\u7248\u672c" + openAPI.getInfo().getSummary());
        BusinessObjectInfo businessObjectInfo = null;
        String businessObjectType = null;
        if (openApiInfo.getBusinessObject() != null) {
            BusinessObject businessObject = openApiInfo.getBusinessObject();
            businessObjectInfo = OpenFeignApiServiceUtil.buildBusinessObjectInfo(openAPI, businessObject);
            businessObjectType = businessObject.businessType();
        } else if (org.springframework.util.StringUtils.hasText((String)openApiInfo.getBusinessObjectType())) {
            businessObjectType = openApiInfo.getBusinessObjectType();
        }
        if (!org.springframework.util.StringUtils.hasText(businessObjectType)) {
            return operation;
        }
        openAPI.addTagsItem(new Tag().name(businessObjectType));
        operation.addTagsItem(businessObjectType);
        BusinessObjectOperationInfo businessObjectOperationInfo = OpenFeignApiServiceUtil.buildBusinessObjectOperation(openApiInfo);
        if (businessObjectOperationInfo != null) {
            if ("@BusinessObject".equals(businessObjectOperationInfo.getBusinessObjectType())) {
                businessObjectOperationInfo.setBusinessObjectType(businessObjectType);
            }
            operation.addExtension(X_BUSINESS_OBJECT_OPERATION, businessObjectOperationInfo);
            StringBuffer summary = new StringBuffer();
            summary.append(operation.getSummary()).append("-").append(businessObjectOperationInfo.getOperationStateEnum().getDescription());
            operation.setSummary(summary.toString());
            operation.addTagsItem(businessObjectOperationInfo.getOperationStateEnum().getDescription());
            operation.addTagsItem(businessObjectOperationInfo.getOperationScopeEnum().getDescription());
        }
        return operation;
    }

    private static BusinessObjectOperationInfo buildBusinessObjectOperation(OpenApiLoadStrategySPI.OpenApiInfo openApiInfo) {
        if (openApiInfo.getBusinessObjectOperation() != null) {
            return BusinessObjectOperationInfo.getBusinessObjectOperationInfo(openApiInfo.getBusinessObjectOperation());
        }
        BusinessObjectOperationInfo businessObjectOperationInfo = new BusinessObjectOperationInfo();
        businessObjectOperationInfo.setEnabled(true);
        businessObjectOperationInfo.setBusinessObjectType(openApiInfo.getBusinessObjectType());
        businessObjectOperationInfo.setOperationCode(openApiInfo.getBusinessOperationCode());
        businessObjectOperationInfo.setOperationType(openApiInfo.getOperationType());
        businessObjectOperationInfo.setOperationDescription(openApiInfo.getOperationDescription());
        businessObjectOperationInfo.setOperationScopeEnum(OperationScopeEnum.PRIVATE_DOMAIN);
        businessObjectOperationInfo.setOperationStateEnum(OperationStateEnum.RELEASED);
        businessObjectOperationInfo.setDataPermissionEnabled(openApiInfo.isDataPermissionEnabled());
        businessObjectOperationInfo.setFieldPermissionAutoFilter(openApiInfo.isDataPermissionEnabled());
        businessObjectOperationInfo.setPermissionRef(openApiInfo.getPermissionRef());
        return businessObjectOperationInfo;
    }

    private static List<OpenApiLoadStrategySPI> loadSpiList() {
        if (!spiList.isEmpty()) {
            return Collections.unmodifiableList(spiList);
        }
        for (OpenApiLoadStrategySPI spi : ServiceLoader.load(OpenApiLoadStrategySPI.class)) {
            spiList.add(spi);
        }
        return Collections.unmodifiableList(spiList);
    }

    private static BusinessObjectInfo buildBusinessObjectInfo(OpenAPI openAPI, BusinessObject businessObject) {
        Map businessObjectMap;
        BusinessObjectInfo businessObjectInfo;
        Map<String, Object> extensions = openAPI.getExtensions();
        if (extensions == null) {
            extensions = new HashMap<String, Object>(8);
            openAPI.extensions(extensions);
        }
        if ((businessObjectInfo = (BusinessObjectInfo)(businessObjectMap = (Map)extensions.computeIfAbsent(X_BUSINESS_OBJECTS, k -> new HashMap())).get(businessObject.businessType())) == null || businessObject.businessDoClass() != null) {
            businessObjectInfo = BusinessObjectInfo.getBusinessObjectInfo(businessObject);
            businessObjectInfo.setParamInfoList(OpenFeignApiServiceUtil.obtainBusinessObjectParamInfoList(businessObject.businessDoClass()));
            businessObjectMap.put(businessObject.businessType(), businessObjectInfo);
        }
        return businessObjectInfo;
    }

    private static String obtainTableName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null && org.springframework.util.StringUtils.hasText((String)table.name())) {
            return table.name();
        }
        org.hibernate.annotations.Table tableHibernate = entityClass.getAnnotation(org.hibernate.annotations.Table.class);
        if (tableHibernate != null && org.springframework.util.StringUtils.hasText((String)tableHibernate.appliesTo())) {
            return tableHibernate.appliesTo();
        }
        return null;
    }

    private static String obtainTableComment(Class<?> entityClass) {
        Comment comment = entityClass.getAnnotation(Comment.class);
        if (comment != null && org.springframework.util.StringUtils.hasText((String)comment.value())) {
            return comment.value();
        }
        org.hibernate.annotations.Comment commentHibernate = entityClass.getAnnotation(org.hibernate.annotations.Comment.class);
        if (commentHibernate != null && org.springframework.util.StringUtils.hasText((String)commentHibernate.value())) {
            return commentHibernate.value();
        }
        org.hibernate.annotations.Table tableHibernate = entityClass.getAnnotation(org.hibernate.annotations.Table.class);
        if (tableHibernate != null && org.springframework.util.StringUtils.hasText((String)tableHibernate.comment())) {
            return tableHibernate.comment();
        }
        return null;
    }

    private static List<BusinessObjectParamInfo.Param> obtainEntityFields(Class<?> entityClass) {
        Object[] fields = ReflectUtil.getFields(entityClass);
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return Collections.emptyList();
        }
        Set<String> baseFields = OpenFeignApiServiceUtil.obtainBaseFields(entityClass);
        boolean isEntityClass = entityClass.isAnnotationPresent(Entity.class) || entityClass.isAnnotationPresent(org.hibernate.annotations.Entity.class);
        return Arrays.stream(fields).filter(field -> {
            if (!baseFields.isEmpty() && baseFields.contains(field.getName())) {
                return true;
            }
            return OpenFeignApiServiceUtil.isNormalField(field, isEntityClass);
        }).map(field -> {
            BusinessParam businessParam;
            BusinessObjectParamInfo.Param param = new BusinessObjectParamInfo.Param();
            param.setFieldName(field.getName());
            param.setColumnName(OpenFeignApiServiceUtil.convertColumnName(field));
            param.setFieldComment(OpenFeignApiServiceUtil.obtainFieldComment(field));
            Class javaType = (Class)ObjectUtil.defaultIfNull(field.getType().getComponentType(), field.getType());
            param.setJavaType(javaType.getName());
            param.setSingle(!field.getType().isArray() && !Collection.class.isAssignableFrom(field.getType()));
            param.setEnumeration(Enum.class.isAssignableFrom(javaType));
            if (param.isEnumeration()) {
                Enumerated enumAnnos = field.getAnnotation(Enumerated.class);
                if (enumAnnos != null) {
                    param.setEnumType(enumAnnos.value().name());
                } else {
                    param.setEnumType(EnumType.ORDINAL.name());
                }
            }
            if ((businessParam = field.getAnnotation(BusinessParam.class)) != null) {
                if (StringUtils.isNotBlank((CharSequence)businessParam.relatedBusinessObject())) {
                    String[] tempArray = businessParam.relatedBusinessObject().split(":");
                    param.setRelatedBusinessObject(tempArray[0]);
                    param.setRelatedField(businessParam.relatedField());
                }
                param.setValues(businessParam.values());
                if (StringUtils.isNotBlank((CharSequence)businessParam.userType())) {
                    param.setUserType(businessParam.userType());
                }
                param.setDataPermissionEnabled(businessParam.dataPermissionEnabled());
                param.setFieldPermissionEnabled(businessParam.fieldPermissionEnabled());
            }
            if (!baseFields.isEmpty()) {
                param.setBaseField(baseFields.contains(field.getName()));
            }
            param.setDeprecated(field.isAnnotationPresent(Deprecated.class));
            return param;
        }).collect(Collectors.toList());
    }

    private static Set<String> obtainBaseFields(Class<?> clazz) {
        if (!BaseModel.class.isAssignableFrom(clazz)) {
            return Collections.emptySet();
        }
        Object[] fields = ReflectUtil.getFields(BaseModel.class);
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return Collections.emptySet();
        }
        return Arrays.stream(fields).filter(t -> OpenFeignApiServiceUtil.isNormalField(t, true)).map(Field::getName).collect(Collectors.toSet());
    }

    private static boolean isNormalField(Field t, boolean isEntity) {
        if (Modifier.isTransient(t.getModifiers())) {
            return false;
        }
        if (t.isAnnotationPresent(Transient.class) || t.isAnnotationPresent(org.springframework.data.annotation.Transient.class)) {
            return false;
        }
        if (Modifier.isStatic(t.getModifiers())) {
            return false;
        }
        if (isEntity) {
            return t.isAnnotationPresent(Column.class);
        }
        return true;
    }

    private static String convertColumnName(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && org.springframework.util.StringUtils.hasText((String)column.name())) {
            return column.name();
        }
        return NamingCase.toUnderlineCase((CharSequence)field.getName());
    }

    private static String obtainFieldComment(Field field) {
        Comment comment = field.getAnnotation(Comment.class);
        if (comment != null && org.springframework.util.StringUtils.hasText((String)comment.value())) {
            return comment.value();
        }
        org.hibernate.annotations.Comment commentHibernate = field.getAnnotation(org.hibernate.annotations.Comment.class);
        if (commentHibernate != null && org.springframework.util.StringUtils.hasText((String)commentHibernate.value())) {
            return commentHibernate.value();
        }
        ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null && org.springframework.util.StringUtils.hasText((String)apiModelProperty.value())) {
            return apiModelProperty.value();
        }
        return null;
    }

    static {
        commonHeaders.add(new HeaderParameter().name("Authorization").required(true).description("\u8ba4\u8bc1\u4ee4\u724c").schema(new StringSchema()));
        commonHeaders.add(new HeaderParameter().name("X-Tenant-Code").required(false).description("\u79df\u6237\u7f16\u7801:\u64cd\u4f5c\u8005\u5982\u679c\u662f\u7b2c\u4e09\u65b9\u5ba2\u6237\u7aef\uff08\u6216\u8005\u5176\u5b83\u672a\u767b\u5f55\u7528\u6237\u7684\u60c5\u51b5\u4e0b\uff09\uff0c\u9700\u8981\u6307\u5b9a\u8bbf\u95ee\u67d0\u79df\u6237\u4e0b\u7684\u6570\u636e\u65f6\u4f20\u9012").schema(new StringSchema()));
        commonHeaders.add(new HeaderParameter().name("X-Tenant-Id").required(false).description("\u540c\u7406X-Tenant-Code\uff0c\u76ee\u524d\u5728\u7528\u7684\u4e1a\u52a1\u573a\u666f\uff1a\u5de5\u4f5c\u6d41\u56de\u8c03\u4e1a\u52a1\u65f6\u4f20\u9012\u7684\u79df\u6237ID").schema(new StringSchema()));
        commonHeaders.add(new HeaderParameter().name("menuCode").required(false).description("\u83dc\u5355\u7f16\u7801\uff1a\u7528\u4e8e\u6570\u636e\u6743\u9650\uff0c\u4f20\u9012\u8bf7\u6c42API\u662f\u54ea\u4e2a\u83dc\u5355").schema(new StringSchema()));
        commonHeaders.add(new HeaderParameter().name("X-Cloudt-BusinessObject").required(false).description("\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\uff1a\u7528\u4e8e\u6570\u636e\u6743\u9650\u4f20\u9012\u5c5e\u4e8e\u54ea\u4e2a\u4e1a\u52a1\u5bf9\u8c61").schema(new StringSchema()));
        commonHeaders.add(new HeaderParameter().name("X-Cloudt-BusinessOperation").required(false).description("\u4e1a\u52a1\u5bf9\u8c61\u7684\u64cd\u4f5c\u7f16\u7801\uff1a\u7528\u4e8e\u6570\u636e\u6743\u9650\u4f20\u9012\u5c5e\u4e8e\u4e1a\u52a1\u5bf9\u8c61\u7684\u54ea\u4e2a\u64cd\u4f5c").schema(new StringSchema()));
    }
}

