/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.swagger.openapi.client.OpenApiRpcProvider;
import com.elitescloud.boot.swagger.openapi.config.OpenApiProperties;
import com.elitescloud.boot.swagger.openapi.config.OpenApiSwaggerConfig;
import com.elitescloud.boot.swagger.openapi.contrlloer.OpenApiController;
import com.elitescloud.boot.swagger.openapi.service.impl.OpenApiService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(prefix="elitesland.openapi", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={OpenApiProperties.class})
@Import(value={OpenApiSwaggerConfig.class})
class CloudtOpenApiAutoConfiguration {
    @Value(value="${spring.application.name:#{''}}")
    private String applicationName;

    CloudtOpenApiAutoConfiguration() {
    }

    @Bean
    public OpenApiService openApiService(ApplicationContext applicationContext, OpenApiProperties openApiProperties) {
        if (CharSequenceUtil.isBlank((CharSequence)openApiProperties.getService())) {
            openApiProperties.setService(this.applicationName);
            openApiProperties.setServiceName(this.applicationName);
        }
        return new OpenApiService(applicationContext, openApiProperties);
    }

    @Bean
    public OpenApiController openApiController(OpenApiService openApiService) {
        return new OpenApiController(openApiService);
    }

    @Bean
    public OpenApiRpcProvider openApiRpcClient(OpenApiService openApiService) {
        return new OpenApiRpcProvider(openApiService);
    }
}

