/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.feignapi;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.swagger.feignapi.DocumentedFeignApi;
import com.elitescloud.boot.swagger.openapi.common.spi.OpenApiLoadStrategySPI;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ProxyUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class OpenApiLoadStrategyRpc
implements OpenApiLoadStrategySPI {
    @Override
    public List<Class<?>> load() {
        Map beansWithAnnotation = SpringContextHolder.getBeansByAnnotation(DocumentedFeignApi.class);
        if (beansWithAnnotation.isEmpty()) {
            return Collections.emptyList();
        }
        return beansWithAnnotation.values().stream().flatMap(t -> {
            Object[] interfaces = ProxyUtil.getTargetClass((Object)t).getInterfaces();
            if (ArrayUtil.isEmpty((Object[])interfaces)) {
                return Stream.empty();
            }
            return Arrays.stream(interfaces).filter(tt -> tt.isAnnotationPresent(DocumentedFeignApi.class));
        }).distinct().collect(Collectors.toList());
    }

    @Override
    public List<OpenApiLoadStrategySPI.OpenApiInfo> analyze(Class<?> clazz) {
        FeignClient requestMapping = clazz.getAnnotation(FeignClient.class);
        if (requestMapping == null) {
            return Collections.emptyList();
        }
        String basePath = requestMapping.path();
        DocumentedFeignApi documentedFeignApi = clazz.getAnnotation(DocumentedFeignApi.class);
        ArrayList<OpenApiLoadStrategySPI.OpenApiInfo> openApiInfos = new ArrayList<OpenApiLoadStrategySPI.OpenApiInfo>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!OpenApiLoadStrategyRpc.isAnnotationMapping(method).booleanValue()) continue;
            DocumentedFeignApi methodAnnotation = method.getAnnotation(DocumentedFeignApi.class);
            String methodPath = OpenApiLoadStrategyRpc.getMethodPath(method);
            OpenApiLoadStrategySPI.OpenApiInfo openApiInfo = new OpenApiLoadStrategySPI.OpenApiInfo(method, OpenApiLoadStrategyRpc.getOperationBasedOnHttpMethod(method), basePath + methodPath);
            openApiInfo.setApiType(2);
            openApiInfo.setOperationGroup(documentedFeignApi.description());
            openApiInfo.setDetail(methodAnnotation != null ? methodAnnotation.description() : "");
            openApiInfo.setOperationDescription(clazz.getName() + "-" + method.getName());
            String returnTypeJson = JSONUtil.toJsonString((Object)method.getGenericReturnType().getTypeName());
            openApiInfo.setReturnTypeJson(returnTypeJson);
            ArrayList<String> parameterTypes = new ArrayList<String>();
            for (Type parameterType : method.getGenericParameterTypes()) {
                parameterTypes.add(parameterType.getTypeName());
            }
            String parameterTypesJson = JSONUtil.toJsonString(parameterTypes);
            openApiInfo.setParameterTypesJson(parameterTypesJson);
            openApiInfos.add(openApiInfo);
        }
        return openApiInfos;
    }

    private static RequestMethod getOperationBasedOnHttpMethod(Method method) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            return RequestMethod.GET;
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return RequestMethod.POST;
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return RequestMethod.PUT;
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return RequestMethod.DELETE;
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return RequestMethod.PATCH;
        }
        if (method.isAnnotationPresent(RequestMapping.class)) {
            RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
            RequestMethod[] methods = requestMapping.method();
            if (methods.length > 0) {
                RequestMethod methodMapping = methods[0];
                switch (methodMapping) {
                    case GET: {
                        return RequestMethod.GET;
                    }
                    case POST: {
                        return RequestMethod.POST;
                    }
                    case PUT: {
                        return RequestMethod.PUT;
                    }
                    case DELETE: {
                        return RequestMethod.DELETE;
                    }
                    case PATCH: {
                        return RequestMethod.PATCH;
                    }
                    case HEAD: {
                        return RequestMethod.HEAD;
                    }
                    case TRACE: {
                        return RequestMethod.TRACE;
                    }
                    case OPTIONS: {
                        return RequestMethod.OPTIONS;
                    }
                }
                throw new RuntimeException("\u672a\u627e\u5230RequestMapping\u6ce8\u89e3" + methodMapping);
            }
            throw new RuntimeException("\u672a\u627e\u5230RequestMapping\u6ce8\u89e3methodMapping");
        }
        throw new RuntimeException("\u672a\u627e\u5230HTTP\u6ce8\u89e3");
    }

    @Override
    public boolean isRequestBody(Parameter parameter) {
        return false;
    }

    private static String getMethodPath(Method method) {
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (getMapping != null && getMapping.value().length > 0) {
            return getMapping.value()[0];
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (postMapping != null && postMapping.value().length > 0) {
            return postMapping.value()[0];
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (putMapping != null && putMapping.value().length > 0) {
            return putMapping.value()[0];
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (deleteMapping != null && deleteMapping.value().length > 0) {
            return deleteMapping.value()[0];
        }
        PatchMapping patchMapping = method.getAnnotation(PatchMapping.class);
        if (patchMapping != null && patchMapping.value().length > 0) {
            return patchMapping.value()[0];
        }
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        if (requestMapping != null && requestMapping.value().length > 0) {
            return requestMapping.value()[0];
        }
        return "";
    }

    private static Boolean isAnnotationMapping(Method method) {
        return CharSequenceUtil.isNotBlank((CharSequence)OpenApiLoadStrategyRpc.getMethodPath(method));
    }
}

