package com.elitescloud.boot.task.delay.common;

import java.io.Serializable;

/**
 * 任务处理器.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
public interface DelayTaskHandler<T extends Serializable> {

    /**
     * 支持的任务类型
     *
     * @return taskType
     */
    String[] supportType();

    /**
     * 处理任务
     *
     * @param taskInfo 任务数据
     * @return 是否执行成功，不成功则会重复调用
     */
    boolean execute(com.elitescloud.cloudt.core.task.delay.TaskInfo<T> taskInfo);
}
