package com.elitescloud.boot.task;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@ConfigurationProperties(prefix = DelayTaskProperties.CONFIG_PREFIX)
public class DelayTaskProperties {
    public static final String CONFIG_PREFIX = "elitesland.delay-task";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 服务类型，redis、rocketMQ
     */
    private String type = "redis";

    /**
     * 刷新间隔
     */
    private Duration interval = Duration.ofSeconds(5);

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Duration getInterval() {
        return interval;
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }
}
