package com.elitescloud.boot.task.delay.common;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 延时任务发送器.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
public interface DelayTaskSender {

    /**
     * 发送延时任务
     *
     * @param taskType  任务类型
     * @param taskKey   任务唯一标识
     * @param payload   负载数据
     * @param delayTime 延迟处理的时间
     */
    <T extends Serializable> void send(String taskType, String taskKey, T payload, LocalDateTime delayTime);

    /**
     * 发送（即时）任务
     *
     * @param taskType 任务类型
     * @param taskKey  任务唯一标识
     * @param payload  负载数据
     */
    <T extends Serializable> void send(String taskType, String taskKey, T payload);

    /**
     * 取消任务
     * <p>
     * 对于即时任务可能无效
     *
     * @param taskType 任务类型
     * @param taskKey  任务唯一标识
     */
    void cancel(String taskType, String taskKey);
}
