/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.delay.support;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.task.delay.common.TaskInfo;
import com.elitescloud.cloudt.core.task.delay.DelayTaskSender;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskSender
implements DelayTaskSender {
    private static final Logger log = LoggerFactory.getLogger(AbstractTaskSender.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    protected <T extends Serializable> void beforeSend(String taskType, String taskKey, T payload, LocalDateTime delayTime) {
        Assert.notBlank((CharSequence)taskType, (String)"\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)taskKey, (String)"\u4efb\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull(payload, (String)"\u8d1f\u8f7d\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u53d1\u9001\u5ef6\u65f6\u4efb\u52a1\uff1a{}-{}\uff1a{}\uff0c\u9884\u8ba1\u5904\u7406\u65f6\u95f4\uff1a{}", new Object[]{taskType, taskKey, payload, this.formatTime(delayTime)});
    }

    protected void beforeCancel(String taskType, String taskKey) {
        Assert.notBlank((CharSequence)taskType, (String)"\u4efb\u52a1\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)taskKey, (String)"\u4efb\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        log.info("\u53d6\u6d88\u5ef6\u65f6\u4efb\u52a1\uff1a{}-{}", (Object)taskKey, (Object)taskKey);
    }

    public <T extends Serializable> TaskInfo<T> buildTask(String taskType, String taskKey, T payload, LocalDateTime delayTime) {
        TaskInfo<T> taskInfo = new TaskInfo<T>();
        taskInfo.setTaskType(taskType);
        taskInfo.setTaskKey(taskKey);
        taskInfo.setPayload(payload);
        taskInfo.setTimeCreate(LocalDateTime.now());
        taskInfo.setDelayTime(delayTime);
        return taskInfo;
    }

    protected String formatTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return DATE_TIME_FORMATTER.format(dateTime);
    }
}

