/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.delay.support.redis;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.task.delay.support.AbstractTaskSender;
import com.elitescloud.boot.task.delay.support.TaskHelper;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisDelayTaskSender
extends AbstractTaskSender {
    private static final Logger log = LoggerFactory.getLogger(RedisDelayTaskSender.class);
    private final RedisTemplate<Object, Object> redisTemplate;
    private final String taskGroup;
    private final String taskDataPrefix;
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.ofHours(8);

    public RedisDelayTaskSender(RedisTemplate<Object, Object> redisTemplate, String taskGroup) {
        this.redisTemplate = redisTemplate;
        this.taskGroup = taskGroup;
        this.taskDataPrefix = TaskHelper.packTaskDataKey(taskGroup);
    }

    @Override
    public <T extends Serializable> void send(String taskType, String taskKey, T payload, LocalDateTime delayTime) {
        LocalDateTime delay = delayTime == null ? LocalDateTime.now() : delayTime;
        this.beforeSend(taskType, taskKey, payload, delay);
        String key = TaskHelper.packTaskKey(taskType, taskKey);
        try {
            this.redisTemplate.opsForZSet().add((Object)this.taskGroup, (Object)key, (double)delay.toEpochSecond(ZONE_OFFSET));
            this.redisTemplate.opsForHash().put((Object)this.taskDataPrefix, (Object)key, this.buildTask(taskType, taskKey, payload, delayTime));
        }
        catch (Exception e) {
            throw new BusinessException("\u53d1\u9001\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public <T extends Serializable> void send(String taskType, String taskKey, T payload) {
        this.send(taskType, taskKey, payload, null);
    }

    @Override
    public void cancel(String taskType, String taskKey) {
        this.beforeCancel(taskType, taskKey);
        String key = TaskHelper.packTaskKey(taskType, taskKey);
        try {
            this.redisTemplate.opsForZSet().remove((Object)this.taskGroup, new Object[]{key});
            this.redisTemplate.opsForHash().delete((Object)this.taskDataPrefix, new Object[]{key});
        }
        catch (Exception e) {
            throw new BusinessException("\u53d6\u6d88\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

