package com.elitescloud.boot.task;

import com.elitescloud.boot.task.delay.support.DelayTaskHandlerFactory;
import com.elitescloud.boot.task.delay.support.DelayTaskListener;
import com.elitescloud.boot.task.delay.support.redis.RedisDelayTaskListener;
import com.elitescloud.boot.task.delay.support.redis.RedisDelayTaskSender;
import com.elitescloud.cloudt.core.task.delay.DelayTaskSender;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

/**
 * 延时任务自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(prefix = DelayTaskProperties.CONFIG_PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@EnableConfigurationProperties(DelayTaskProperties.class)
@Import({CloudtDelayTaskAutoConfiguration.RedisDelayTaskConfig.class})
class CloudtDelayTaskAutoConfiguration {

    @Bean
    public DelayTaskHandlerFactory delayTaskHandlerFactory() {
        return new DelayTaskHandlerFactory();
    }

    @ConditionalOnProperty(prefix = DelayTaskProperties.CONFIG_PREFIX, name = "type", havingValue = "redis", matchIfMissing = true)
    @ConditionalOnClass(RedisTemplate.class)
    static class RedisDelayTaskConfig {
        @Value("${spring.application.name:#{''}}")
        private String applicationName;
        private final DelayTaskProperties delayTaskProperties;

        public RedisDelayTaskConfig(DelayTaskProperties delayTaskProperties) {
            this.delayTaskProperties = delayTaskProperties;
        }

        @Bean
        public DelayTaskListener redisDelayTaskListener(RedisTemplate<Object, Object> redisTemplate) {
            return new RedisDelayTaskListener(redisTemplate, applicationName + "-delayTask", delayTaskProperties.getInterval());
        }

        @Bean
        public DelayTaskSender redisDelayTaskSender(RedisTemplate<Object, Object> redisTemplate) {
            return new RedisDelayTaskSender(redisTemplate, applicationName + "-delayTask");
        }
    }
}
