/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task;

import com.elitescloud.boot.task.DelayTaskProperties;
import com.elitescloud.boot.task.delay.support.DelayTaskHandlerFactory;
import com.elitescloud.boot.task.delay.support.DelayTaskListener;
import com.elitescloud.boot.task.delay.support.redis.RedisDelayTaskListener;
import com.elitescloud.boot.task.delay.support.redis.RedisDelayTaskSender;
import com.elitescloud.cloudt.core.task.delay.DelayTaskSender;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.delay-task", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={DelayTaskProperties.class})
@Import(value={RedisDelayTaskConfig.class})
class CloudtDelayTaskAutoConfiguration {
    CloudtDelayTaskAutoConfiguration() {
    }

    @Bean
    public DelayTaskHandlerFactory delayTaskHandlerFactory() {
        return new DelayTaskHandlerFactory();
    }

    @ConditionalOnProperty(prefix="elitesland.delay-task", name={"type"}, havingValue="redis", matchIfMissing=true)
    @ConditionalOnClass(value={RedisTemplate.class})
    static class RedisDelayTaskConfig {
        @Value(value="${spring.application.name:#{''}}")
        private String applicationName;
        private final DelayTaskProperties delayTaskProperties;

        public RedisDelayTaskConfig(DelayTaskProperties delayTaskProperties) {
            this.delayTaskProperties = delayTaskProperties;
        }

        @Bean
        public DelayTaskListener redisDelayTaskListener(RedisTemplate<Object, Object> redisTemplate) {
            return new RedisDelayTaskListener(redisTemplate, this.applicationName + "-delayTask", this.delayTaskProperties.getInterval());
        }

        @Bean
        public DelayTaskSender redisDelayTaskSender(RedisTemplate<Object, Object> redisTemplate) {
            return new RedisDelayTaskSender(redisTemplate, this.applicationName + "-delayTask");
        }
    }
}

