package com.elitescloud.boot.task.delay.common;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 任务信息.
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@Data
public class TaskInfo<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = -4845394141086838948L;

    /**
     * 任务类型
     */
    private String taskType;

    /**
     * 任务的唯一标识
     */
    private String taskKey;

    /**
     * 负载数据
     */
    private T payload;

    /**
     * 任务创建时间
     */
    private LocalDateTime timeCreate;

    /**
     * 延时处理时间
     */
    private LocalDateTime delayTime;
}
