package com.elitescloud.boot.task.delay.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.task.delay.common.DelayTaskHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/25
 */
@Slf4j
public class DelayTaskHandlerFactory implements ApplicationContextAware, InitializingBean {

    private ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        loadServices();
    }

    private void loadServices() {
        // 获取任务处理器
        var handlers = applicationContext.getBeansOfType(DelayTaskHandler.class).values();
        if (CollUtil.isEmpty(handlers)) {
            log.debug("未获取到延时任务的处理器");
            return;
        }

        // 获取支持的服务监听器
        var taskListeners = applicationContext.getBeansOfType(DelayTaskListener.class).values();
        if (CollectionUtils.isEmpty(taskListeners)) {
            log.debug("未获取到有效的延时处理服务");
            return;
        }

        // 注册处理器
        Map<String, Set<DelayTaskHandler>> handlerMap = new HashMap<>(64);
        handlers.forEach(t -> {
            var types = t.supportType();
            Assert.notEmpty(types, "延时任务处理器【{}】未配置supportType", t.getClass().getName());
            for (var type : types) {
                handlerMap.computeIfAbsent(type, k -> new HashSet<>(8)).add(t);
            }
        });

        taskListeners.forEach(t -> t.registerHandler(handlerMap));
    }
}
