/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.delay.support.redis;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.task.delay.common.DelayTaskHandler;
import com.elitescloud.boot.task.delay.support.DelayTaskListener;
import com.elitescloud.boot.task.delay.support.TaskHelper;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class RedisDelayTaskListener<T extends Serializable>
implements DelayTaskListener<T>,
SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RedisDelayTaskListener.class);
    private final RedisTemplate<Object, Object> redisTemplate;
    private final String taskGroup;
    private final Duration interval;
    private Map<String, Set<DelayTaskHandler<T>>> taskHandlers;
    private ScheduledTaskRegistrar scheduledTaskRegistrar;
    private static final ZoneOffset ZONE_OFFSET = ZoneOffset.ofHours(8);
    private final String taskDataPrefix;

    public RedisDelayTaskListener(RedisTemplate<Object, Object> redisTemplate, String taskGroup, Duration interval) {
        this.redisTemplate = redisTemplate;
        this.taskGroup = taskGroup;
        this.interval = interval;
        this.taskDataPrefix = TaskHelper.packTaskDataKey(taskGroup);
    }

    @Override
    public void registerHandler(Map<String, Set<DelayTaskHandler<T>>> delayTaskHandlers) {
        log.info("Redis\u83b7\u53d6\u5ef6\u65f6\u4efb\u52a1\u65f6\u95f4\u95f4\u9694\uff1a{}s", (Object)this.interval.toSeconds());
        this.taskHandlers = delayTaskHandlers;
        this.registerTask();
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        this.scheduledTaskRegistrar = taskRegistrar;
        this.registerTask();
    }

    private void registerTask() {
        if (CollUtil.isEmpty(this.taskHandlers)) {
            return;
        }
        if (this.scheduledTaskRegistrar == null) {
            return;
        }
        this.scheduledTaskRegistrar.addFixedDelayTask(this::pullTopic, this.interval.toMillis());
    }

    private void pullTopic() {
        try {
            this.execPull();
        }
        catch (Exception e) {
            log.info("Redis\u83b7\u53d6\u5ef6\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
    }

    private void execPull() throws Exception {
        Set taskList = this.redisTemplate.opsForZSet().rangeByScore((Object)this.taskGroup, 0.0, (double)LocalDateTime.now().toEpochSecond(ZONE_OFFSET));
        if (CollUtil.isNotEmpty((Collection)taskList)) {
            taskList.forEach(key -> {
                Object value = this.redisTemplate.opsForHash().get((Object)this.taskDataPrefix, key);
                if (value != null) {
                    this.redisTemplate.opsForHash().delete((Object)this.taskDataPrefix, new Object[]{key});
                    TaskInfo taskInfo = (TaskInfo)value;
                    Set<DelayTaskHandler<DelayTaskHandler>> handlers = this.taskHandlers.get(taskInfo.getTaskType());
                    if (CollUtil.isEmpty(handlers)) {
                        log.warn("\u672a\u627e\u5230\u5ef6\u65f6\u4efb\u52a1\u3010{}\u3011\u7684\u5904\u7406\u5668", (Object)taskInfo.getTaskType());
                    } else {
                        handlers.forEach(service -> {
                            log.info("\u5ef6\u65f6\u4efb\u52a1\u3010{}\u3011\u7684\u6d88\u606f\uff1a{}", (Object)service.getClass().getName(), (Object)taskInfo);
                            try {
                                service.execute(taskInfo);
                            }
                            catch (Exception e) {
                                log.info("\u5ef6\u65f6\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                            }
                        });
                    }
                }
                this.redisTemplate.opsForZSet().remove((Object)this.taskGroup, new Object[]{key});
            });
        }
    }
}

