package com.elitescloud.boot.task.retry;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 重试任务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/14
 */
@Data
public class RetryTask implements Serializable {
    private static final long serialVersionUID = -4470530632535228892L;

    /**
     * 任务ID
     * <p>
     * 不可为空且唯一
     */
    @NotBlank
    private String taskId;

    /**
     * 版本
     */
    private int version;

    /**
     * 重试次数
     */
    private int retryTimes;

    /**
     * 重试时间
     */
    private LocalDateTime retryTime;
}
