package com.elitescloud.boot.task.retry;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 重试任务提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/14
 */
public interface RetryTaskProvider<T extends RetryTask> {

    /**
     * 查询待重试的任务列表
     *
     * @param lastTaskId 上批记录中最后一条任务ID
     * @param size       获取数量
     * @return 任务列表
     */
    List<T> queryTask(String lastTaskId, int size);

    /**
     * 删除重试的任务
     *
     * @param taskId 任务ID
     * @param reason 删除原因
     */
    void deleteTask(@NotBlank String taskId, String reason);

    /**
     * 尝试发送任务
     *
     * @param taskId  任务ID
     * @param version 任务版本
     * @return 是否可以发送
     */
    boolean trySend(@NotBlank String taskId, Integer version);

    /**
     * 更新任务重试发送结果
     *
     * @param taskId  任务ID
     * @param success    是否发送成功
     * @param failReason 发送失败原因
     */
    void updateRetryResult(String taskId, boolean success, String failReason);
}
