package com.elitescloud.boot.task.retry;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 重试服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/14
 */
public interface RetryableService<T extends RetryTask> {

    /**
     * 添加重试任务
     *
     * @param retryTask 重试任务
     */
    void addRetryTask(@NotNull T retryTask);

    /**
     * 生成下次发送时间
     *
     * @param lastSendTime 上次发送时间
     * @param retryTimes   已重试次数
     * @return 下次发送时间，为空则不再重试
     */
    LocalDateTime generateNextRetryTime(@NotNull LocalDateTime lastSendTime, int retryTimes);
}
