/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.retry;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.task.retry.RetryTask;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.boot.task.retry.RetryableService;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.Assert;

public abstract class AbstractRetryService<T extends RetryTask>
implements SchedulingConfigurer,
RetryableService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRetryService.class);
    private final RetryTaskProvider<T> retryTaskProvider;
    private final RedissonClient redissonClient;
    private RetryTaskQueueWrapper<T> retryTaskQueueWrapper = null;

    protected AbstractRetryService(RetryTaskProvider<T> retryTaskProvider, RedissonClient redissonClient) {
        this.retryTaskProvider = retryTaskProvider;
        this.redissonClient = redissonClient;
    }

    protected abstract boolean supportRetry();

    protected abstract int retryTimes();

    protected abstract List<Duration> retryIntervals();

    protected abstract void executeTask(T var1);

    protected String threadPrefix() {
        return "common-";
    }

    protected Duration scheduleDelay() {
        return Duration.ofMinutes(30L);
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addFixedDelayTask(() -> {
            if (!this.supportRetry()) {
                return;
            }
            try {
                this.addRetryTaskToQueue();
            }
            catch (Exception e) {
                log.error("\u5b9a\u65f6\u6267\u884c\u6dfb\u52a0\u4efb\u52a1\u91cd\u8bd5\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, this.scheduleDelay().toMillis());
    }

    @Override
    public void addRetryTask(T retryTask) {
        Assert.hasText((String)((RetryTask)retryTask).getTaskId(), (String)"\u4efb\u52a1ID\u4e3a\u7a7a");
        if (((RetryTask)retryTask).getRetryTime() == null) {
            String msg = this.supportRetry() ? "\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570" : "\u91cd\u8bd5\u529f\u80fd\u5df2\u7981\u7528";
            log.info("\u5220\u9664\u91cd\u8bd5\u4efb\u52a1\uff1a{}\uff0c{}\uff0c{}", new Object[]{((RetryTask)retryTask).getTaskId(), ((RetryTask)retryTask).getRetryTimes(), msg});
            this.retryTaskProvider.deleteTask(((RetryTask)retryTask).getTaskId(), msg);
            return;
        }
        if (this.retryTaskQueueWrapper == null) {
            this.initQueue();
        }
        this.retryTaskQueueWrapper.addTask(retryTask);
    }

    @Override
    public LocalDateTime generateNextRetryTime(LocalDateTime lastSendTime, int retryTimes) {
        if (!this.supportRetry()) {
            log.info("\u91cd\u8bd5\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u91cd\u8bd5");
            return null;
        }
        int max = this.retryTimes();
        if (retryTimes >= max) {
            log.info("\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u4e0d\u518d\u91cd\u8bd5");
            return null;
        }
        List<Duration> intervals = this.retryIntervals();
        if (CollUtil.isEmpty(intervals)) {
            log.error("\u6d88\u606f\u91cd\u8bd5\u95f4\u9694\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u91cd\u8bd5");
            return null;
        }
        Duration interval = retryTimes > intervals.size() - 1 ? intervals.get(intervals.size() - 1) : intervals.get(retryTimes);
        return lastSendTime.plusSeconds(interval.toSeconds());
    }

    private void addRetryTaskToQueue() {
        List<T> taskList;
        String lastTaskId = null;
        while (!CollUtil.isEmpty(taskList = this.retryTaskProvider.queryTask(lastTaskId, 50))) {
            for (RetryTask task : taskList) {
                this.addRetryTask(task);
                lastTaskId = task.getTaskId();
            }
        }
    }

    private void initQueue() {
        this.retryTaskQueueWrapper = new RetryTaskQueueWrapper<RetryTask>(this.threadPrefix(), 2000, (task, size) -> {
            RLock lock;
            boolean executed;
            Throwable exp;
            block15: {
                block16: {
                    block17: {
                        exp = null;
                        executed = false;
                        lock = this.redissonClient.getLock(this.threadPrefix() + "retry-" + task.getTaskId() + "-" + task.getVersion());
                        if (!lock.tryLock(1L, TimeUnit.MINUTES)) break block15;
                        if (this.retryTaskProvider.trySend(task.getTaskId(), task.getVersion())) break block16;
                        log.info("\u4efb\u52a1{}, {}\u4e0d\u9700\u8981\u518d\u91cd\u8bd5", (Object)task.getTaskId(), (Object)task.getVersion());
                        if (!executed) break block17;
                        try {
                            this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                        }
                        catch (Exception e) {
                            log.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                    }
                    lock.unlock();
                    return;
                }
                try {
                    log.info("\u91cd\u8bd5\u4efb\u52a1\uff1a{}", (Object)task.getTaskId());
                    executed = true;
                    this.executeTask(task);
                    log.info("\u91cd\u8bd5\u4efb\u52a1\u6210\u529f\uff1a{}", (Object)task.getTaskId());
                }
                catch (Throwable e) {
                    block18: {
                        try {
                            log.error("\u6267\u884c\u91cd\u8bd5\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)task.getTaskId(), (Object)e);
                            exp = e;
                            if (!executed) break block18;
                        }
                        catch (Throwable throwable) {
                            if (executed) {
                                try {
                                    this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                                }
                                catch (Exception e2) {
                                    log.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e2);
                                }
                            }
                            lock.unlock();
                            throw throwable;
                        }
                        try {
                            this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                        }
                        catch (Exception e3) {
                            log.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e3);
                        }
                    }
                    lock.unlock();
                }
            }
            if (executed) {
                try {
                    this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            lock.unlock();
        });
    }

    static class DelayTask<T extends RetryTask>
    implements Delayed {
        private final T retryTask;
        private final LocalDateTime sendTime;

        public DelayTask(T retryTask) {
            this.retryTask = retryTask;
            this.sendTime = ((RetryTask)retryTask).getRetryTime();
            Assert.notNull((Object)this.sendTime, (String)"\u91cd\u8bd5\u65f6\u95f4\u4e3a\u7a7a");
        }

        @Override
        public long getDelay(@NonNull TimeUnit unit) {
            return unit.convert(Duration.between(LocalDateTime.now(), this.sendTime));
        }

        @Override
        public int compareTo(@NonNull Delayed o) {
            if (o == this) {
                return 0;
            }
            if (o instanceof DelayTask) {
                DelayTask msg = (DelayTask)o;
                return this.getSendTime().compareTo(msg.getSendTime());
            }
            return 0;
        }

        public T getRetryTask() {
            return this.retryTask;
        }

        public LocalDateTime getSendTime() {
            return this.sendTime;
        }
    }

    static class RetryTaskQueueWrapper<T extends RetryTask> {
        private final String threadPrefix;
        private final DelayQueue<DelayTask<T>> queue = new DelayQueue();
        private final Set<String> taskIdsAll = new HashSet<String>();
        private final int size;
        private final BiConsumer<T, Integer> consumer;

        public RetryTaskQueueWrapper(String threadPrefix, int size, BiConsumer<T, Integer> consumer) {
            this.threadPrefix = threadPrefix;
            this.size = size;
            this.consumer = consumer;
            this.consumeMessage();
        }

        public void addTask(T task) {
            String taskId = ((RetryTask)task).getTaskId();
            Assert.hasText((String)taskId, (String)"\u6dfb\u52a0\u91cd\u8bd5\u961f\u5217\u5931\u8d25\uff0c\u4efb\u52a1ID\u4e3a\u7a7a");
            if (this.taskIdsAll.contains(taskId)) {
                return;
            }
            if (this.queue.size() >= this.size) {
                log.info("\u91cd\u8bd5\u961f\u5217\u5df2\u6ee1");
                return;
            }
            this.queue.add(new DelayTask<T>(task));
            this.taskIdsAll.add(taskId);
        }

        private void consumeMessage() {
            Runnable runnable = () -> {
                while (true) {
                    DelayTask task;
                    try {
                        task = (DelayTask)this.queue.take();
                    }
                    catch (InterruptedException e) {
                        log.error("\u4ece\u6d88\u606f\u961f\u5217\u83b7\u53d6\u5ef6\u8fdf\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                        continue;
                    }
                    this.taskIdsAll.remove(((RetryTask)task.getRetryTask()).getTaskId());
                    try {
                        this.consumer.accept(task.getRetryTask(), this.queue.size());
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u5ef6\u65f6\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                        continue;
                    }
                    break;
                }
            };
            Thread threadConsumer = DaemonThreadFactory.INSTANCE.newThread(runnable);
            threadConsumer.setName(this.threadPrefix + "retry");
            threadConsumer.setDaemon(true);
            threadConsumer.setUncaughtExceptionHandler((t, e) -> log.error("\u91cd\u8bd5\u670d\u52a1\u5f02\u5e38\uff1a", e));
            threadConsumer.start();
        }
    }
}

