/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.delay.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.task.delay.common.DelayTaskHandler;
import com.elitescloud.boot.task.delay.support.DelayTaskListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class DelayTaskHandlerFactory
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DelayTaskHandlerFactory.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.loadServices();
    }

    private void loadServices() {
        Collection handlers = this.applicationContext.getBeansOfType(DelayTaskHandler.class).values();
        if (CollUtil.isEmpty(handlers)) {
            log.debug("\u672a\u83b7\u53d6\u5230\u5ef6\u65f6\u4efb\u52a1\u7684\u5904\u7406\u5668");
            return;
        }
        Collection taskListeners = this.applicationContext.getBeansOfType(DelayTaskListener.class).values();
        if (CollectionUtils.isEmpty(taskListeners)) {
            log.debug("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u5ef6\u65f6\u5904\u7406\u670d\u52a1");
            return;
        }
        HashMap handlerMap = new HashMap(64);
        handlers.forEach(t -> {
            Object[] types = t.supportType();
            Assert.notEmpty((Object[])types, (String)"\u5ef6\u65f6\u4efb\u52a1\u5904\u7406\u5668\u3010{}\u3011\u672a\u914d\u7f6esupportType", (Object[])new Object[]{t.getClass().getName()});
            for (Object type : types) {
                handlerMap.computeIfAbsent(type, k -> new HashSet(8)).add(t);
            }
        });
        taskListeners.forEach(t -> t.registerHandler(handlerMap));
    }
}

