/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.task.retry;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.task.retry.RetryTask;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.boot.task.retry.RetryableService;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.LockUtil;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.Assert;

public abstract class AbstractRetryService<T extends RetryTask>
implements SchedulingConfigurer,
RetryableService<T> {
    private static final Logger logger = CloudtBootLoggerFactory.JOB_RETRY.getLogger(AbstractRetryService.class);
    private final RetryTaskProvider<T> retryTaskProvider;
    protected final TenantDataIsolateProvider tenantDataIsolateProvider;
    private RetryTaskQueueWrapper<T> retryTaskQueueWrapper = null;

    protected AbstractRetryService(RetryTaskProvider<T> retryTaskProvider, TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.retryTaskProvider = retryTaskProvider;
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }

    protected abstract boolean supportRetry();

    protected abstract int retryTimes();

    protected abstract List<Duration> retryIntervals();

    protected abstract void executeTask(T var1);

    protected String threadPrefix() {
        return "common-";
    }

    protected Duration scheduleDelay() {
        return Duration.ofMinutes(30L);
    }

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addFixedDelayTask(() -> {
            if (!this.supportRetry()) {
                return;
            }
            try {
                this.addRetryTaskToQueue();
            }
            catch (Exception e) {
                logger.error("\u5b9a\u65f6\u6267\u884c\u6dfb\u52a0\u4efb\u52a1\u91cd\u8bd5\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, this.scheduleDelay().toMillis());
    }

    @Override
    public void addRetryTask(T retryTask) {
        Assert.hasText((String)((RetryTask)retryTask).getTaskId(), (String)"\u4efb\u52a1ID\u4e3a\u7a7a");
        if (((RetryTask)retryTask).getRetryTime() == null) {
            String msg = this.supportRetry() ? "\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570" : "\u91cd\u8bd5\u529f\u80fd\u5df2\u7981\u7528";
            logger.info("\u5220\u9664\u91cd\u8bd5\u4efb\u52a1\uff1a{}\uff0c{}\uff0c{}", new Object[]{((RetryTask)retryTask).getTaskId(), ((RetryTask)retryTask).getRetryTimes(), msg});
            this.retryTaskProvider.deleteTask(((RetryTask)retryTask).getTaskId(), msg);
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (((RetryTask)retryTask).getRetryTime().isBefore(now)) {
            logger.info("\u4efb\u52a1\u5df2\u8fc7\u671f\uff1a{}, {}", (Object)((RetryTask)retryTask).getTaskId(), (Object)DatetimeUtil.toStr((LocalDateTime)((RetryTask)retryTask).getRetryTime()));
            return;
        }
        if (((RetryTask)retryTask).getRetryTime().isAfter(now.plusSeconds(this.scheduleDelay().toSeconds() * 4L))) {
            logger.info("\u4efb\u52a1\u7684\u6267\u884c\u65f6\u95f4\u8fd8\u65e9\uff0c\u6682\u4e0d\u52a0\u5165\u961f\u5217\uff1a{}, {}", (Object)((RetryTask)retryTask).getTaskId(), (Object)DatetimeUtil.toStr((LocalDateTime)((RetryTask)retryTask).getRetryTime()));
            return;
        }
        if (this.retryTaskQueueWrapper == null) {
            this.initQueue();
        }
        this.retryTaskQueueWrapper.addTask(retryTask);
    }

    @Override
    public LocalDateTime generateNextRetryTime(LocalDateTime lastSendTime, int retryTimes) {
        if (!this.supportRetry()) {
            logger.info("\u91cd\u8bd5\u5df2\u5173\u95ed\uff0c\u65e0\u9700\u91cd\u8bd5");
            return null;
        }
        int max = this.retryTimes();
        if (retryTimes >= max) {
            logger.info("\u5df2\u8fbe\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0c\u4e0d\u518d\u91cd\u8bd5");
            return null;
        }
        List<Duration> intervals = this.retryIntervals();
        if (CollUtil.isEmpty(intervals)) {
            logger.error("\u6d88\u606f\u91cd\u8bd5\u95f4\u9694\u672a\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u91cd\u8bd5");
            return null;
        }
        Duration interval = retryTimes > intervals.size() - 1 ? intervals.get(intervals.size() - 1) : intervals.get(retryTimes);
        return lastSendTime.plusSeconds(interval.toSeconds());
    }

    private void addRetryTaskToQueue() {
        List<T> taskList;
        String lastTaskId = null;
        while (!CollUtil.isEmpty(taskList = this.retryTaskProvider.queryTask(lastTaskId, 50))) {
            for (RetryTask task : taskList) {
                this.addRetryTask(task);
                lastTaskId = task.getTaskId();
            }
        }
    }

    private void initQueue() {
        this.retryTaskQueueWrapper = new RetryTaskQueueWrapper<RetryTask>(this.threadPrefix(), 2000, (task, size) -> {
            Throwable exp = null;
            AtomicBoolean executed = new AtomicBoolean(false);
            LockUtil.executeByLock((String)(this.threadPrefix() + "retry-" + task.getTaskId() + "-" + task.getVersion()), () -> {
                if (!this.retryTaskProvider.trySend(task.getTaskId(), task.getVersion())) {
                    logger.info("\u4efb\u52a1\u4e0d\u9700\u8981\u518d\u91cd\u8bd5\uff1a{}, {}", (Object)task.getTaskId(), (Object)task.getVersion());
                    return null;
                }
                logger.info("\u91cd\u8bd5\u4efb\u52a1\uff1a{}", (Object)task.getTaskId());
                if (!this.supportRetry()) {
                    this.retryTaskProvider.updateRetryResult(task.getTaskId(), false, "\u81ea\u52a8\u91cd\u8bd5\u529f\u80fd\u672a\u542f\u7528");
                    return null;
                }
                executed.set(true);
                this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                    this.executeTask(task);
                    return null;
                });
                logger.info("\u91cd\u8bd5\u4efb\u52a1\u6210\u529f\uff1a{}", (Object)task.getTaskId());
                return null;
            }, (Duration)Duration.ofMinutes(1L));
            if (!executed.get()) return;
            try {
                this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                return;
            }
            catch (Exception e) {
                logger.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e);
            }
            return;
            catch (Throwable e) {
                try {
                    logger.error("\u6267\u884c\u91cd\u8bd5\u4efb\u52a1\u5f02\u5e38\uff1a{}", (Object)task.getTaskId(), (Object)e);
                    exp = e;
                    if (!executed.get()) return;
                }
                catch (Throwable throwable) {
                    if (!executed.get()) throw throwable;
                    try {
                        this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                        throw throwable;
                    }
                    catch (Exception e2) {
                        logger.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.retryTaskProvider.updateRetryResult(task.getTaskId(), exp == null, exp == null ? null : ExceptionsUtil.stackTraceAllToString((Throwable)exp));
                    return;
                }
                catch (Exception e3) {
                    logger.error("\u66f4\u65b0\u4efb\u52a1\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff1a", (Throwable)e3);
                }
                return;
            }
        });
    }

    static class RetryTaskQueueWrapper<T extends RetryTask> {
        private final String threadPrefix;
        private final DelayQueue<DelayTask<T>> queue = new DelayQueue();
        private final Set<String> taskIdsAll = new HashSet<String>();
        private final int size;
        private final BiConsumer<T, Integer> consumer;

        public RetryTaskQueueWrapper(String threadPrefix, int size, BiConsumer<T, Integer> consumer) {
            this.threadPrefix = threadPrefix;
            this.size = size;
            this.consumer = consumer;
            this.consumeMessage();
        }

        public void addTask(T task) {
            String taskId = ((RetryTask)task).getTaskId();
            Assert.hasText((String)taskId, (String)"\u6dfb\u52a0\u91cd\u8bd5\u961f\u5217\u5931\u8d25\uff0c\u4efb\u52a1ID\u4e3a\u7a7a");
            if (this.taskIdsAll.contains(taskId)) {
                return;
            }
            if (this.queue.size() >= this.size) {
                logger.info("\u91cd\u8bd5\u961f\u5217\u5df2\u6ee1");
                return;
            }
            this.queue.add(new DelayTask<T>(task));
            this.taskIdsAll.add(taskId);
        }

        private void consumeMessage() {
            Runnable runnable = () -> {
                while (true) {
                    DelayTask task;
                    try {
                        task = (DelayTask)this.queue.take();
                    }
                    catch (InterruptedException e) {
                        logger.error("\u4ece\u6d88\u606f\u961f\u5217\u83b7\u53d6\u5ef6\u8fdf\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                        continue;
                    }
                    this.taskIdsAll.remove(((RetryTask)task.getRetryTask()).getTaskId());
                    try {
                        this.consumer.accept(task.getRetryTask(), this.queue.size());
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u5ef6\u65f6\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                        continue;
                    }
                    break;
                }
            };
            Thread threadConsumer = DaemonThreadFactory.INSTANCE.newThread(runnable);
            threadConsumer.setName(this.threadPrefix + "retry");
            threadConsumer.setDaemon(true);
            threadConsumer.setUncaughtExceptionHandler((t, e) -> logger.error("\u91cd\u8bd5\u670d\u52a1\u5f02\u5e38\uff1a", e));
            threadConsumer.start();
        }
    }

    static class DelayTask<T extends RetryTask>
    implements Delayed {
        private final T retryTask;
        private final LocalDateTime sendTime;

        public DelayTask(T retryTask) {
            this.retryTask = retryTask;
            this.sendTime = ((RetryTask)retryTask).getRetryTime();
            Assert.notNull((Object)this.sendTime, (String)"\u91cd\u8bd5\u65f6\u95f4\u4e3a\u7a7a");
        }

        @Override
        public long getDelay(@NonNull TimeUnit unit) {
            return unit.convert(Duration.between(LocalDateTime.now(), this.sendTime));
        }

        @Override
        public int compareTo(@NonNull Delayed o) {
            if (o == this) {
                return 0;
            }
            if (o instanceof DelayTask) {
                DelayTask msg = (DelayTask)o;
                return this.getSendTime().compareTo(msg.getSendTime());
            }
            return 0;
        }

        public T getRetryTask() {
            return this.retryTask;
        }

        public LocalDateTime getSendTime() {
            return this.sendTime;
        }
    }
}

