package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.elitescloud.boot.condition.ConditionalOnTenant;

import lombok.extern.log4j.Log4j2;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import javax.sql.DataSource;

/**
 * 租户客户端自动化配置.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@ConditionalOnTenant
@Import({SpringDatasourceDynamicTenantProperties.class/*,WebMvcConfig.class*/})
@ConditionalOnProperty(prefix = "spring.datasource.dynamic.tenant",name = "switch",havingValue = "true")
@Log4j2
public class CloudtTenantClientAutoConfiguration {


    private final DefaultDataSourceCreator dataSourceCreator;
    private final DataSource dataSource;
    private final SpringDatasourceDynamicTenantProperties datasourceProperties;




    public CloudtTenantClientAutoConfiguration(
                                               DefaultDataSourceCreator dataSourceCreator,
                                               DataSource dataSource,
                                               SpringDatasourceDynamicTenantProperties datasourceProperties) {

        this.dataSourceCreator = dataSourceCreator;
        this.dataSource = dataSource;
        this.datasourceProperties = datasourceProperties;
    }

    @Bean
    public StartupRunner newStartupRunner(){
        return new StartupRunner(
                dataSourceCreator,
                dataSource,
                datasourceProperties);
    }



//    public WebInterceptor newWebInterceptor(){
//        return new WebInterceptor(datasourceProperties,dataSource);
//    }

}
