package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/6 16:59
 */

@Slf4j
public class WebInterceptor implements HandlerInterceptor {

    private DataSource dataSource;
//    private String appName;
    private SpringDatasourceDynamicTenantProperties datasourceProperties;
    public WebInterceptor(SpringDatasourceDynamicTenantProperties datasourceProperties, DataSource dataSource) {
//        this.appName=appName;
        this.dataSource = dataSource;
        this.datasourceProperties=datasourceProperties;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        var user = SecurityContextUtil.currentUser();
        if (user == null) {
            log.error("线程切换租户数据源失败：无法获取当前用户信息,"+SecurityContextUtil.currentToken());
          //  throw new RuntimeException("线程切换租户数据源失败：无法获取当前用户信息，token："+SecurityContextUtil.currentToken());
           throw new BusinessException(ApiCode.UNAUTHORIZED, "请先登录");
        }
        // 解析对应的租户
        SysTenantDTO tenant = user.getUser().getSysTenantVO();
        if (tenant != null) {
            String tenantCode=tenant.getTenantCode();
            String dsDataSourceName = datasourceProperties.getAppName() + "_" + tenantCode;
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource) dataSource;
            var mapDs = ds.getDataSources();
            //-1标识租户使用共享主库
            if(tenant.getId()==-1){
                log.info("数据源使用共享主库，不使用租户服务数据源库：tenantID={}",tenant.getId());
            }else {
                log.info("开始使用租户服务数据源库：tenantID={}",tenant.getId());
                if (mapDs.containsKey(dsDataSourceName)) {
                    //执行切换
                    DynamicDataSourceContextHolder.push(dsDataSourceName);
                    log.info("线程切换租户数据源到：{}", dsDataSourceName);
                } else {
                    log.error("不存在租户数据源，线程切换租户数据源失败：{}", dsDataSourceName);
                    throw new BusinessException(ApiCode.UNAUTHORIZED, "请先登录");
                   // throw new RuntimeException("线程切换租户数据源失败：" + dsDataSourceName + ",不存在租户数据源,请检查租户微服务数据源配置。");
                }
                // 如果返回true，请求将继续执行；如果返回false，请求将被终止
            }
            return true;
        }else{
            log.error("线程切换租户数据源跳过：没有当前用户租户信息，{}",user.getUser());
            throw new BusinessException(ApiCode.UNAUTHORIZED, "请先登录");
            //throw new RuntimeException("线程切换租户数据源跳过：没有当前用户租户信息， "+user.getUser());

        }

    }

    /****清空线程，避免线程复用下次请求继续使用租户数据源。***/
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        DynamicDataSourceContextHolder.clear();
    }

}

