package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.spi.TenantContextSpi;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import lombok.extern.slf4j.Slf4j;

import javax.sql.DataSource;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/7
 */
@Slf4j
public class TenantDatasourceTenantContextSpi implements TenantContextSpi {

    @Override
    public void onSetTenant(SysTenantDTO tenant) {
        if (tenant == null) {
            return;
        }
        String tenantCode=tenant.getTenantCode();
        var prop = SpringContextHolder.getObjectProvider(SpringDatasourceDynamicTenantProperties.class).getIfAvailable();
        if (prop == null || !prop.isTenantDataSourceSwitch()) {
            log.debug("未启用多数据源");
            return;
        }
        String dsDataSourceName = prop.getAppName() + "_" + tenantCode;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource) SpringContextHolder.getBean(DataSource.class);
        var mapDs = ds.getDataSources();
        //-1标识租户使用共享主库
        if(tenant.getId()==-1){
            log.info("数据源使用共享主库，不使用租户服务数据源库：tenantID={}",tenant.getId());
        }else {
            log.info("开始使用租户服务数据源库：tenantID={}",tenant.getId());
            if (mapDs.containsKey(dsDataSourceName)) {
                //执行切换
                DynamicDataSourceContextHolder.push(dsDataSourceName);
                log.info("线程切换租户数据源到：{}", dsDataSourceName);
            } else {
                log.error("不存在租户数据源，线程切换租户数据源失败：{}", dsDataSourceName);
                throw new BusinessException(ApiCode.UNAUTHORIZED, "请先登录");
                // throw new RuntimeException("线程切换租户数据源失败：" + dsDataSourceName + ",不存在租户数据源,请检查租户微服务数据源配置。");
            }
            // 如果返回true，请求将继续执行；如果返回false，请求将被终止
        }
    }

    @Override
    public void onClearTenant(SysTenantDTO tenant) {
        DynamicDataSourceContextHolder.clear();
    }
}
