package com.elitescloud.boot.tenant.datasources;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.sql.DataSource;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/6 16:59
 */

@Slf4j
public class WebMvcConfig implements WebMvcConfigurer {

    private final DataSource dataSource;
    private final  SpringDatasourceDynamicTenantProperties datasourceProperties;
    @Value("${spring.application.name}")
    private  final String appName = null;

    public WebMvcConfig(DataSource dataSource, SpringDatasourceDynamicTenantProperties datasourceProperties) {
        this.dataSource = dataSource;
        this.datasourceProperties = datasourceProperties;
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        if(datasourceProperties.isTenantDataSourceSwitch()) {
            registry.addInterceptor(new WebInterceptor(datasourceProperties,dataSource))
                    // 拦截所有以/api/开头的请求
                    .addPathPatterns(datasourceProperties.getIncludePatterns())
                    // 排除/api/login和/api/logout
                    .excludePathPatterns(datasourceProperties.getExcludePatterns());
            log.info("注册租户多数据源切换拦截器完成：{}",datasourceProperties);
        }else{
            log.info("注册租户多数据源切换拦截器跳过：未开启多租户多数据源配置");
        }
    }
}
