package com.elitescloud.boot.tenant.datasources;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author : chen.niu
 * @description : 多租户多数据源配置文件
 * @date : 2023/10/6 20:05
 */
public class SpringDatasourceDynamicTenantProperties {
    @Value("${spring.application.name}")
    private String appName=null;

    /**
     * 是否启用多租户多数据源功能
     */
    @Value("${spring.datasource.dynamic.tenant.switch:false}")
    private boolean tenantDataSourceSwitch = false;
    /**
     * 那些API需要启用多租户多数据源动态切换
     */
    @Value("${spring.datasource.dynamic.tenant.include-patterns}")
    private String[] includePatterns=new String[0];
    /**
     * 那些API不需要启用多租户多数据源动态切换
     **/
    @Value("${spring.datasource.dynamic.tenant.exclude-patterns}")
    private String[] excludePatterns=new String[0];

    public boolean isTenantDataSourceSwitch() {
        return tenantDataSourceSwitch;
    }
    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
    public void setTenantDataSourceSwitch(boolean tenantDataSourceSwitch) {
        this.tenantDataSourceSwitch = tenantDataSourceSwitch;
    }

    public String[] getIncludePatterns() {
        return includePatterns;
    }

    public void setIncludePatterns(String[] includePatterns) {
        this.includePatterns = includePatterns;
    }

    public String[] getExcludePatterns() {
        return excludePatterns;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }
}
