package com.elitescloud.boot.tenant.datasources;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/8 17:23
 */

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 服务租户数据源配置;
 * @author : http://www.chiner.pro
 * @date : 2023-10-8
 */
@Getter
@Setter
@Accessors(chain = true)
public class SysDatabaseServiceTenantDTO extends BaseModel implements Serializable {

    /**
     * 数据源名称
     */
    private String dbsName;
    /**
     * 驱动类
     */
    private String dbsDriverClass;
    /**
     * 服务器地址字符串{dbsNetaddress}：{dbsDbPort}：{dbsDbName}：占位
     */
    private String dbsUrl;
    /**
     * 数据库名称
     */
    private String dbsDbName;
    /**
     * 数据库端口
     */
    private String dbsDbPort;
    /**
     * 账号
     */
    private String dbsUsername;
    /**
     * 密码
     */
    private String dbsPassword;
    private String dbsNetaddress;
    /**
     * 服务编码
     */
    private String serviceCode;
    /**
     * 数据源租户编码
     */
    private String tenantCode;
    /**
     * 租户组织ID
     */
    private Long tenantOrgId;
}
