/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.datasources;

import com.elitescloud.boot.tenant.datasources.SpringDatasourceDynamicTenantProperties;
import com.elitescloud.boot.tenant.datasources.WebInterceptor;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    private final DataSource dataSource;
    private final SpringDatasourceDynamicTenantProperties datasourceProperties;
    @Value(value="${spring.application.name}")
    private final String appName;

    public WebMvcConfig(DataSource dataSource, SpringDatasourceDynamicTenantProperties datasourceProperties) {
        this.appName = null;
        this.dataSource = dataSource;
        this.datasourceProperties = datasourceProperties;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.datasourceProperties.isTenantDataSourceSwitch()) {
            registry.addInterceptor((HandlerInterceptor)new WebInterceptor(this.datasourceProperties, this.dataSource)).addPathPatterns(this.datasourceProperties.getIncludePatterns()).excludePathPatterns(this.datasourceProperties.getExcludePatterns());
            log.info("\u6ce8\u518c\u79df\u6237\u591a\u6570\u636e\u6e90\u5207\u6362\u62e6\u622a\u5668\u5b8c\u6210\uff1a{}", (Object)this.datasourceProperties);
        } else {
            log.info("\u6ce8\u518c\u79df\u6237\u591a\u6570\u636e\u6e90\u5207\u6362\u62e6\u622a\u5668\u8df3\u8fc7\uff1a\u672a\u5f00\u542f\u591a\u79df\u6237\u591a\u6570\u636e\u6e90\u914d\u7f6e");
        }
    }
}

