/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceProperty;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.elitescloud.boot.tenant.datasources.SpringDatasourceDynamicTenantProperties;
import com.elitescloud.boot.tenant.datasources.SysDatabaseServiceTenantDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=-2147483648)
public class StartupRunner
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(StartupRunner.class);
    private final DefaultDataSourceCreator dataSourceCreator;
    private final DataSource dataSource;
    private final SpringDatasourceDynamicTenantProperties datasourceProperties;

    public StartupRunner(DefaultDataSourceCreator dataSourceCreator, DataSource dataSource, SpringDatasourceDynamicTenantProperties datasourceProperties) {
        this.dataSourceCreator = dataSourceCreator;
        this.dataSource = dataSource;
        this.datasourceProperties = datasourceProperties;
    }

    public void afterPropertiesSet() {
        try {
            if (this.datasourceProperties.isTenantDataSourceSwitch()) {
                String appName = this.datasourceProperties.getAppName();
                log.info("\u591a\u79df\u6237\u6570\u636e\u6e90\u521d\u59cb\u5316\u6267\u884c-\u5f00\u59cb");
                List<SysDatabaseServiceTenantDTO> tenantDataSources = this.querySysDatabase();
                tenantDataSources.forEach(tenantDataSource -> {
                    if (StringUtils.hasText((String)tenantDataSource.getServiceCode())) {
                        if (tenantDataSource.getServiceCode().equals(appName)) {
                            log.info("\u79df\u6237\u6570\u636e\u6e90\u5f00\u59cb\u521d\u59cb\u5316\u542f\u52a8\uff1a\u79df\u6237\u7f16\u7801\uff1a{}\uff0c{}", (Object)tenantDataSource.getTenantCode(), (Object)tenantDataSource.getServiceCode());
                            DataSourceProperty dataSourceProperty = StartupRunner.getDataSourceProperty(tenantDataSource);
                            DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
                            DataSource dataSource = this.dataSourceCreator.createDataSource(dataSourceProperty);
                            ds.addDataSource(appName + "_" + tenantDataSource.getTenantCode(), dataSource);
                            log.info("\u79df\u6237\u6570\u636e\u6e90\u5f00\u59cb\u521d\u59cb\u5316\u542f\u52a8\u5b8c\u6bd5\uff1a\u79df\u6237\u7f16\u7801\uff1a{}\uff0c{}", (Object)tenantDataSource.getTenantCode(), (Object)tenantDataSource.getServiceCode());
                        } else {
                            log.info("\u975e\u672c\u670d\u52a1\u6570\u636e\u6e90\u8df3\u8fc7\u521d\u59cb\u5316\uff1a{}!={}", (Object)appName, (Object)tenantDataSource.getServiceCode());
                        }
                    } else {
                        log.error("\u6570\u636e\u6e90\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u7f16\u7801{}", (Object)tenantDataSource.getServiceCode());
                    }
                });
                log.info("\u591a\u79df\u6237\u6570\u636e\u6e90\u6267\u884c-\u7ed3\u675f");
            } else {
                log.info("\u672a\u5f00\u542f\u591a\u79df\u6237\u591a\u6570\u636e\u6e90\uff0c\u91c7\u7528\u591a\u79df\u6237\u5355\u6570\u636e\u6e90\u903b\u8f91\u9694\u79bb: {}", (Object)this.datasourceProperties);
            }
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    private static DataSourceProperty getDataSourceProperty(SysDatabaseServiceTenantDTO tenantDataSource) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("dbsNetaddress", tenantDataSource.getDbsNetaddress());
        replacements.put("dbsDbPort", tenantDataSource.getDbsDbPort());
        replacements.put("dbsDbName", tenantDataSource.getDbsName());
        String dbsUrl = StartupRunner.replaceNamedPlaceholders(tenantDataSource.getDbsUrl(), replacements);
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        dataSourceProperty.setDriverClassName(tenantDataSource.getDbsDriverClass());
        dataSourceProperty.setUrl(dbsUrl);
        dataSourceProperty.setUsername(tenantDataSource.getDbsUsername());
        dataSourceProperty.setPassword(tenantDataSource.getDbsPassword());
        return dataSourceProperty;
    }

    public static String replaceNamedPlaceholders(String str, Map<String, String> replacements) {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            str = str.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SysDatabaseServiceTenantDTO> querySysDatabase() throws SQLException {
        ArrayList<SysDatabaseServiceTenantDTO> resultList = new ArrayList<SysDatabaseServiceTenantDTO>();
        if (this.dataSource.getConnection() != null) {
            String sql = "SELECT * FROM sys_database_source sd where sd.deleteFlag=0";
            try (Statement statement = this.dataSource.getConnection().createStatement();
                 ResultSet rs = statement.executeQuery(sql);){
                while (rs.next()) {
                    SysDatabaseServiceTenantDTO dto = new SysDatabaseServiceTenantDTO();
                    dto.setDbsName(rs.getString("dbs_name")).setDbsDriverClass(rs.getString("dbs_driver_class")).setDbsUrl(rs.getString("dbs_url")).setDbsDbName(rs.getString("dbs_db_name")).setDbsDbPort(rs.getString("dbs_db_port")).setDbsUsername(rs.getString("dbs_username")).setDbsNetaddress(rs.getString("dbs_netaddress")).setDbsPassword(rs.getString("dbs_password")).setServiceCode(rs.getString("service_code")).setTenantCode(rs.getString("tenant_code")).setTenantOrgId(rs.getLong("tenant_org_id"));
                    resultList.add(dto);
                }
            }
            catch (Exception e) {
                log.error("\u591a\u79df\u6237\u591a\u6570\u636e\u6e90\u521d\u59cb\u5316\u5f02\u5e38\uff1a" + e.getMessage());
            }
            finally {
                try {
                    this.dataSource.getConnection().close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultList;
    }
}

