/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.spi.TenantContextSpi;
import com.elitescloud.boot.tenant.datasources.SpringDatasourceDynamicTenantProperties;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantDatasourceTenantContextSpi
implements TenantContextSpi {
    private static final Logger log = LoggerFactory.getLogger(TenantDatasourceTenantContextSpi.class);

    public void onSetTenant(SysTenantDTO tenant) {
        if (tenant == null) {
            return;
        }
        String tenantCode = tenant.getTenantCode();
        SpringDatasourceDynamicTenantProperties prop = (SpringDatasourceDynamicTenantProperties)SpringContextHolder.getObjectProvider(SpringDatasourceDynamicTenantProperties.class).getIfAvailable();
        if (prop == null || !prop.isTenantDataSourceSwitch()) {
            log.debug("\u672a\u542f\u7528\u591a\u6570\u636e\u6e90");
            return;
        }
        String dsDataSourceName = prop.getAppName() + "_" + tenantCode;
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)SpringContextHolder.getBean(DataSource.class);
        Map mapDs = ds.getDataSources();
        if (tenant.getId() == -1L) {
            log.info("\u6570\u636e\u6e90\u4f7f\u7528\u5171\u4eab\u4e3b\u5e93\uff0c\u4e0d\u4f7f\u7528\u79df\u6237\u670d\u52a1\u6570\u636e\u6e90\u5e93\uff1atenantID={}", (Object)tenant.getId());
        } else {
            log.info("\u5f00\u59cb\u4f7f\u7528\u79df\u6237\u670d\u52a1\u6570\u636e\u6e90\u5e93\uff1atenantID={}", (Object)tenant.getId());
            if (mapDs.containsKey(dsDataSourceName)) {
                DynamicDataSourceContextHolder.push((String)dsDataSourceName);
                log.info("\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u5230\uff1a{}", (Object)dsDataSourceName);
            } else {
                log.error("\u4e0d\u5b58\u5728\u79df\u6237\u6570\u636e\u6e90\uff0c\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u5931\u8d25\uff1a{}", (Object)dsDataSourceName);
                throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
            }
        }
    }

    public void onClearTenant(SysTenantDTO tenant) {
        DynamicDataSourceContextHolder.clear();
    }
}

