package com.elitescloud.boot.tenant.client.support.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.tenant.client.common.TenantRequestUtil;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.util.List;

/**
 * 租户客户端提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/21
 */
public class DefaultTenantClientProvider implements TenantClientProvider {

    private final TenantClientProperties clientProperties;

    public DefaultTenantClientProvider(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Override
    public boolean enabledTenant() {
        return clientProperties.isEnabled();
    }

    @Override
    public SysTenantDTO getCurrentTenant() {
        return TenantClient.getCurrentTenant();
    }

    @Override
    public SysTenantDTO getSessionTenant() {
        return TenantClient.getSessionTenant();
    }

    @Override
    public SysTenantDTO getTenant(Long sysTenantId) {
        return TenantClient.getTenant(sysTenantId);
    }

    @Override
    public SysTenantDTO getTenantByCode(String tenantCode) {
        return TenantClient.getTenant(tenantCode);
    }

    @Override
    public List<SysTenantDTO> getAllTenants() {
        return TenantClient.getAllTenants();
    }

    @Override
    public SysTenantDTO obtainTenantFromRequest() {
        return TenantClient.obtainTenantFromRequest();
    }

    @Override
    public boolean isDefaultDomainRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return false;
        }

        String domain = TenantRequestUtil.obtainTenantDomain(((ServletRequestAttributes) requestAttributes).getRequest());

        return CharSequenceUtil.equals(domain, clientProperties.getTenantDomain());
    }
}
