package com.elitescloud.boot.tenant.client.common;

import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;

/**
 * 租户数据库RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@Validated
public interface TenantDatabaseRpcProvider {

    /**
     * schema创建
     *
     * @param schema schema名称
     * @return 创建结果
     */
    @GetMapping(value = "/schemaCreate")
    ApiResult<Boolean> schemaCreate(@RequestParam(value = "schema") @NotBlank(message = "schema为空") String schema);

    /**
     * schema删除
     *
     * @param schema schema名称
     * @return 删除结果
     */
    @GetMapping(value = "/schemaDrop")
    ApiResult<Boolean> schemaDrop(@RequestParam(value = "schema") @NotBlank(message = "schema为空") String schema);
}
