package com.elitescloud.boot.tenant.client;

import com.elitescloud.boot.constant.CacheKey;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

/**
 * 租户客户端配置属性.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@ConfigurationProperties(prefix = TenantClientProperties.CONFIG_PREFIX)
public class TenantClientProperties {

    public static final String CONFIG_PREFIX = TenantConstant.CONFIG_SERVICE_PREFIX + ".client";

    /**
     * 是否启用客户端
     */
    private boolean enabled = true;

    /**
     * 租户路径拦截
     */
    private String pathPattern = "/**";

    /**
     * 排除掉的路径
     */
    private Set<String> excludePattern = new HashSet<>();

    /**
     * 默认schema
     */
    private String defaultSchema;

    /**
     * 租户域名地址
     */
    private String tenantDomain = "tenant.elitesland.com";
    /**
     * 租户域名与我们的域名直接的分隔符
     */
    private String tenantDomainDelimiter = ".";

    /**
     * 同步数据库信息重试次数，默认3次
     */
    private int syncDbRetryTimes = 3;

    /**
     * 失败后重试间隔，默认1分钟
     */
    private Duration retryInterval = Duration.ofMinutes(2);

    /**
     * 数据库隔离策略，默认不隔离
     */
    private TenantIsolateStrategy isolateStrategy = TenantIsolateStrategy.NONE;

    /**
     * 租户间redis是否隔离
     */
    private boolean redisSeparate = true;
    /**
     * 默认的redis Key 前缀
     */
    private String defaultRedisKeyPrefix = CacheKey.PREFIX_DEFAULT;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getPathPattern() {
        return pathPattern;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public Set<String> getExcludePattern() {
        return excludePattern;
    }

    public void setExcludePattern(Set<String> excludePattern) {
        this.excludePattern = excludePattern;
    }

    public String getDefaultSchema() {
        return defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getTenantDomain() {
        return tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public String getTenantDomainDelimiter() {
        return tenantDomainDelimiter;
    }

    public void setTenantDomainDelimiter(String tenantDomainDelimiter) {
        this.tenantDomainDelimiter = tenantDomainDelimiter;
    }

    public int getSyncDbRetryTimes() {
        return syncDbRetryTimes;
    }

    public void setSyncDbRetryTimes(int syncDbRetryTimes) {
        this.syncDbRetryTimes = syncDbRetryTimes;
    }

    public Duration getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(Duration retryInterval) {
        this.retryInterval = retryInterval;
    }

    public TenantIsolateStrategy getIsolateStrategy() {
        return isolateStrategy;
    }

    public void setIsolateStrategy(TenantIsolateStrategy isolateStrategy) {
        this.isolateStrategy = isolateStrategy;
    }

    public boolean isRedisSeparate() {
        return redisSeparate;
    }

    public void setRedisSeparate(boolean redisSeparate) {
        this.redisSeparate = redisSeparate;
    }

    public String getDefaultRedisKeyPrefix() {
        return defaultRedisKeyPrefix;
    }

    public void setDefaultRedisKeyPrefix(String defaultRedisKeyPrefix) {
        this.defaultRedisKeyPrefix = defaultRedisKeyPrefix;
    }
}
