/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.tenant.client.common.TenantRequestUtil;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.List;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DefaultTenantClientProvider
implements TenantClientProvider {
    private final TenantClientProperties clientProperties;

    public DefaultTenantClientProvider(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public boolean enabledTenant() {
        return this.clientProperties.isEnabled();
    }

    public SysTenantDTO getCurrentTenant() {
        return TenantClient.getCurrentTenant();
    }

    public SysTenantDTO getSessionTenant() {
        return TenantClient.getSessionTenant();
    }

    public SysTenantDTO getTenant(Long sysTenantId) {
        return TenantClient.getTenant(sysTenantId);
    }

    public SysTenantDTO getTenantByCode(String tenantCode) {
        return TenantClient.getTenant(tenantCode);
    }

    public List<SysTenantDTO> getAllTenants() {
        return TenantClient.getAllTenants();
    }

    public SysTenantDTO obtainTenantFromRequest() {
        return TenantClient.obtainTenantFromRequest();
    }

    public boolean isDefaultDomainRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return false;
        }
        String domain = TenantRequestUtil.obtainTenantDomain(((ServletRequestAttributes)requestAttributes).getRequest());
        return CharSequenceUtil.equals((CharSequence)domain, (CharSequence)this.clientProperties.getTenantDomain());
    }

    public void clearCache() {
        TenantClient.clearCache();
    }
}

