package com.elitescloud.boot.tenant.client.support.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.provider.TenantOrgProvider;

/**
 * 租户组织提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2023/7/19
 */
public class DefaultTenantOrgProvider implements TenantOrgProvider {

    @Override
    public Long getCurrentTenantOrgId() {
        var currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return null;
        }

        return currentUser.getTenantOrgId();
    }

    @Override
    public Long getSessionTenantOrgId() {
        Boolean used = TenantOrgContext.isUseTenantOrg();
        if (used != null && !used) {
            // 目前不使用租户组织
            return null;
        }

        return ObjectUtil.defaultIfNull(TenantOrgContext.getTenantOrg(), this.getCurrentTenantOrgId());
    }
}
