/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.config;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.tenant.client.common.AbstractTenantIsolateDelegate;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TenantTransactionWrapper
extends AbstractTenantIsolateDelegate<Object, Object, TransactionStatus>
implements TransactionWrapper<Object, Object> {
    private static final Logger log = LogManager.getLogger(TenantTransactionWrapper.class);
    private static final String TRANSACTION_NAME_PREFIX = "cloudt_tenant";
    private final PlatformTransactionManager transactionManager;

    public TenantTransactionWrapper(PlatformTransactionManager platformTransactionManager) {
        this.transactionManager = platformTransactionManager;
    }

    public String transactionName() {
        return TRANSACTION_NAME_PREFIX;
    }

    @Override
    protected boolean supportApply(SysTenantDTO tenant) {
        String currentTransactionName = TransactionSynchronizationManager.getCurrentTransactionName();
        String newTransactionName = this.generateTransactionName(tenant);
        log.debug("Transaction try\uff1a{} -> {}", (Object)currentTransactionName, (Object)newTransactionName);
        return !CharSequenceUtil.equals((CharSequence)newTransactionName, (CharSequence)currentTransactionName);
    }

    @Override
    protected TransactionStatus beforeApply(Supplier<Object> supplier, SysTenantDTO tenant) {
        String newTransactionName = this.generateTransactionName(tenant);
        log.debug("Transaction execute\uff1a{} -> {}", new org.apache.logging.log4j.util.Supplier[]{TransactionSynchronizationManager::getCurrentTransactionName, () -> newTransactionName});
        return this.buildTenantTransactionDefinition(newTransactionName);
    }

    @Override
    protected void afterCompletion(Object result, TransactionStatus transactionStatus, boolean useDefault, Exception exp) {
        if (transactionStatus == null) {
            return;
        }
        if (exp == null) {
            this.transactionManager.commit(transactionStatus);
            return;
        }
        this.transactionManager.rollback(transactionStatus);
    }

    private TransactionStatus buildTenantTransactionDefinition(String newTransactionName) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        definition.setName(newTransactionName);
        return this.transactionManager.getTransaction((TransactionDefinition)definition);
    }

    private String generateTransactionName(SysTenantDTO tenant) {
        return TRANSACTION_NAME_PREFIX + (String)(tenant == null || tenant.getType() == TenantType.OPERATION ? "[default]" : "[" + tenant.getId() + "]");
    }
}

