/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.config;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

@Aspect
public class TenantTransactionAspect
implements Ordered {
    private static final Logger log = LogManager.getLogger(TenantTransactionAspect.class);
    private final TransactionWrapper tenantTransactionWrapper;

    public TenantTransactionAspect(TransactionWrapper tenantTransactionWrapper) {
        this.tenantTransactionWrapper = tenantTransactionWrapper;
    }

    @Pointcut(value="@annotation(com.elitescloud.cloudt.core.annotation.TenantTransaction)")
    private void pointCutMethod() {
    }

    @Pointcut(value="@within(com.elitescloud.cloudt.core.annotation.TenantTransaction)")
    private void pointCutClass() {
    }

    @Around(value="pointCutClass() || pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        TenantTransaction annotation = this.obtainAnnotation(point);
        Assert.notNull((Object)annotation, (String)"\u672a\u83b7\u53d6\u5230TenantTransaction\u6ce8\u89e3\u4fe1\u606f");
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (annotation.supportOperation() && currentUser != null && currentUser.isOperation()) {
            return this.execute(point, "ISOLATABLE_NONE");
        }
        SysTenantDTO tenant = this.obtainTenant(annotation, currentUser);
        return this.execute(point, tenant);
    }

    private Object execute(ProceedingJoinPoint point, Object param) throws Throwable {
        return this.tenantTransactionWrapper.apply(() -> {
            try {
                return point.proceed();
            }
            catch (Throwable e) {
                ExceptionsUtil.wrapAndThrow((Throwable)e);
                return null;
            }
        }, param);
    }

    private TenantTransaction obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            TenantTransaction annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(TenantTransaction.class);
            if (annotation == null) {
                annotation = point.getThis().getClass().getAnnotation(TenantTransaction.class);
            }
            return annotation;
        }
        return null;
    }

    private SysTenantDTO obtainTenant(TenantTransaction annotation, GeneralUserDetails currentUser) {
        TenantIsolateType isolateType = annotation.isolateType();
        if (isolateType == TenantIsolateType.DEFAULT) {
            return null;
        }
        if (TenantSession.getUseDefault() || TenantSession.getNoTenant()) {
            return null;
        }
        SysTenantDTO currentTenant = (SysTenantDTO)ObjectUtil.defaultIfNull((Object)TenantSession.getCurrentTenant(), (Object)TenantContextHolder.getCurrentTenant());
        if (currentTenant != null) {
            if (isolateType == TenantIsolateType.TENANT || currentUser == null) {
                return currentTenant;
            }
            if (isolateType == TenantIsolateType.TENANT_USER) {
                if (currentUser.isSystemAdmin() || currentUser.isOperation() || currentUser.isTenantAdmin()) {
                    return null;
                }
                return currentTenant;
            }
            return null;
        }
        if (annotation.tenantRequired()) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u4fe1\u606f");
        }
        return null;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

