package com.elitescloud.boot.tenant.client.support.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.threadpool.common.ContextTransfer;

/**
 * 租户上下文信息传递.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/30
 */
public class TenantOrgContextTransfer implements ContextTransfer<Long> {

    @Override
    public Long getContext() {
        if (ObjectUtil.defaultIfNull(TenantOrgContext.isUseTenantOrg(), true)) {
            return TenantOrgContext.getTenantOrg();
        }
        return null;
    }

    @Override
    public void setContext(Long context) {
        if (context != null) {
            TenantOrgContext.setTenantOrgId(context);
        }
    }

    @Override
    public void clearContext() {
        TenantOrgContext.clearUseTenantOrg();
    }
}
