package com.elitescloud.boot.context;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

/**
 * 租户环境.
 *
 * @author Kaiser（wang shao）
 * @date 4/6/2023
 */
@ConditionalOnTenant
class TenantEnvironmentListener implements SmartApplicationListener {

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        TenantContextHolder.setEnabledTenant(true);
    }
}
