package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.threadpool.common.ContextTransfer;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;

/**
 * 租户上下文信息传递.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/30
 */
public class TenantContextTransfer implements ContextTransfer<SysTenantDTO> {

    private final TenantClientProvider tenantClientProvider;

    public TenantContextTransfer(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Override
    public SysTenantDTO getContext() {
        return tenantClientProvider.getSessionTenant();
    }

    @Override
    public void setContext(SysTenantDTO context) {
        if (context != null) {
            TenantContextHolder.setCurrentTenant(context);
        }
    }

    @Override
    public void clearContext() {
        TenantContextHolder.clearCurrentTenant();
    }
}
