package com.elitescloud.boot.tenant.client;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.redis.CloudtRedisAutoConfiguration;
import com.elitescloud.boot.redis.common.support.RedisKeyPrefix;
import com.elitescloud.boot.tenant.client.support.config.TenantRedisWrapper;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.constant.CacheKey;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;

/**
 * 租户相关Redis配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/22/2023
 */
@ConditionalOnTenant
@AutoConfigureBefore(CloudtRedisAutoConfiguration.class)
class CloudtTenantRedisAutoConfiguration {

    @Bean(RedisWrapper.TENANT)
    public RedisWrapper tenantRedisWrapper() {
        return new TenantRedisWrapper();
    }

    @Bean
    public RedisKeyPrefix tenantRedisKeyPrefix(TenantClientProperties clientProperties) {
        return () -> {
            if (!clientProperties.isRedisSeparate()) {
                // 租户不根据key前缀分离redis
                return CacheKey.PREFIX_DEFAULT;
            }

            if (TenantSession.getUseDefault() || TenantSession.getNoTenant()) {
                // 使用默认的
                return clientProperties.getDefaultRedisKeyPrefix();
            }

            SysTenantDTO tenant = TenantSession.getCurrentTenant();
            if (tenant == null) {
                tenant = TenantContextHolder.getCurrentTenant();
            }

            if (tenant == null) {
                return clientProperties.getDefaultRedisKeyPrefix();
            }
            return "tenant_" + tenant.getTenantCode();
        };
    }
}
