package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.support.CloudtInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 租户组织设置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/25
 */
@Slf4j
public class TenantOrgRequestInterceptor implements CloudtInterceptor {

    @Override
    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        var tenantOrgId = this.obtainTenantOrgId(request);
        if (tenantOrgId != null) {
            TenantOrgContext.setTenantOrgId(tenantOrgId);
        }
        return true;
    }

    @Override
    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantOrgContext.cleaTenantOrgId();
    }

    private Long obtainTenantOrgId(HttpServletRequest request) {
        var tenantOrgId = request.getHeader(TenantConstant.HEADER_TENANT_ORG_ID);
        if (StringUtils.hasText(tenantOrgId)) {
            try {
                return Long.parseLong(tenantOrgId);
            } catch (NumberFormatException e) {
                log.error("租户组织ID解析失败：{}", tenantOrgId, e);
            }
        }
        return null;
    }
}
