/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.condition.ConditionalOnRpc;
import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.flyway.common.FlywayBuilder;
import com.elitescloud.boot.flyway.common.FlywayHelper;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import com.elitescloud.boot.tenant.client.support.TenantProviderService;
import com.elitescloud.boot.tenant.client.support.config.DefaultTenantClientProvider;
import com.elitescloud.boot.tenant.client.support.impl.ClientSyncTenantProvider;
import com.elitescloud.boot.tenant.client.support.impl.DefaultTenantProvider;
import com.elitescloud.boot.tenant.client.support.impl.TenantContextTransfer;
import com.elitescloud.boot.tenant.client.support.impl.TenantDatabaseRpcProviderImpl;
import com.elitescloud.boot.tenant.client.support.impl.TenantOrgContextTransfer;
import com.elitescloud.boot.tenant.client.support.impl.TenantRequestInterceptor;
import com.elitescloud.boot.tenant.client.support.impl.TenantSchemaInitializer;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.core.tenant.support.TenantClientProvider;
import com.elitescloud.cloudt.tenant.provider.TenantProvider;
import java.util.Collections;
import org.apache.dubbo.config.spring.context.annotation.DubboComponentScan;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.task.TaskExecutor;

@ConditionalOnTenant
@EnableConfigurationProperties(value={TenantClientProperties.class})
@Import(value={OnDubbo.class, OnOpenFeign.class})
public class CloudtTenantClientAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtTenantClientAutoConfiguration.class);
    private final TenantClientProperties clientProperties;

    public CloudtTenantClientAutoConfiguration(TenantClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        log.info("\u542f\u7528\u79df\u6237\uff0c\u79df\u6237\u9694\u79bb\u65b9\u5f0f\uff1a{}", (Object)clientProperties.getIsolateStrategy());
        if (clientProperties.getIsolateStrategy() == TenantIsolateStrategy.SCHEMA) {
            log.info("\u9ed8\u8ba4schema\uff1a{} ", (Object)clientProperties.getDefaultSchema());
            Assert.notBlank((CharSequence)clientProperties.getDefaultSchema(), (String)"\u79df\u6237\u4f7f\u7528Schema\u9694\u79bb\u65f6\u9ed8\u8ba4schema\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public TenantProviderService tenantProviderService() {
        log.warn("\u672a\u53d1\u73b0\u6709\u6548\u7684\u79df\u6237\u670d\u52a1\u63d0\u4f9b\u8005");
        return () -> ApiResult.ok(Collections.emptyList());
    }

    @Bean
    public TenantProvider defaultTenantProvider(TenantProviderService tenantProviderService, ObjectProvider<RedisUtils> redisUtils, RedisWrapper redisWrapper) {
        return new DefaultTenantProvider(tenantProviderService, (RedisUtils)redisUtils.getIfAvailable(), redisWrapper);
    }

    @Bean
    @ConditionalOnTenant(isolateStrategy={TenantIsolateStrategy.SCHEMA, TenantIsolateStrategy.DATABASE})
    public ClientSyncTenantProvider clientSyncTenantProvider(TenantProvider tenantProvider, FlywayHelper flywayHelper, FlywayBuilder flywayBuilder) {
        return new ClientSyncTenantProvider(this.clientProperties, tenantProvider, flywayHelper, flywayBuilder);
    }

    @Bean
    @ConditionalOnTenant(isolateStrategy={TenantIsolateStrategy.SCHEMA, TenantIsolateStrategy.DATABASE})
    public TenantSchemaInitializer tenantSchemaInitializer(ClientSyncTenantProvider clientSyncTenantProvider, TaskExecutor taskExecutor) {
        return new TenantSchemaInitializer(clientSyncTenantProvider, taskExecutor, this.clientProperties);
    }

    @Bean
    public TenantRequestInterceptor tenantRequestInterceptor() {
        return new TenantRequestInterceptor(this.clientProperties);
    }

    @Bean
    public TenantClientProvider tenantClientProvider() {
        return new DefaultTenantClientProvider(this.clientProperties);
    }

    @Bean
    public TenantContextTransfer tenantContextTransfer(com.elitescloud.boot.provider.TenantClientProvider tenantClientProvider) {
        return new TenantContextTransfer(tenantClientProvider);
    }

    @Bean
    public TenantOrgContextTransfer tenantOrgContextTransfer() {
        return new TenantOrgContextTransfer();
    }

    @ConditionalOnRpc(requiredOpenFeign=true)
    static class OnOpenFeign {
        public OnOpenFeign() {
            log.debug("\u79df\u6237\u5ba2\u6237\u7aef\u5df2\u542f\u7528OpenFeign\u8fdc\u7a0b\u8c03\u7528");
        }

        @Bean
        public TenantDatabaseRpcProvider tenantDatabaseRpcProvider() {
            return new TenantDatabaseRpcProviderImpl();
        }
    }

    @ConditionalOnRpc(requiredDubbo=true)
    @DubboComponentScan(basePackages={"com.elitesland.cloudt.tenant.rpc.consumer"})
    static class OnDubbo {
        public OnDubbo() {
            log.debug("\u79df\u6237\u5ba2\u6237\u7aef\u5df2\u542f\u7528dubbo\u8fdc\u7a0b\u8c03\u7528");
        }
    }
}

