/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultTenantDataIsolateProvider
implements TenantDataIsolateProvider {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT.getLogger(DefaultTenantDataIsolateProvider.class);
    private final TransactionWrapper transactionWrapper;
    private final TenantClientProvider tenantClientProvider;

    public DefaultTenantDataIsolateProvider(TransactionWrapper transactionWrapper, TenantClientProvider tenantClientProvider) {
        this.transactionWrapper = transactionWrapper;
        this.tenantClientProvider = tenantClientProvider;
    }

    public <T> T byNone(Supplier<T> supplier) {
        return (T)this.transactionWrapper.apply(supplier, (Object)"ISOLATABLE_NONE");
    }

    public <T> T byDefaultDirectly(Supplier<T> supplier) {
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenantDirectly(Supplier<T> supplier, SysTenantDTO tenantDTO) {
        return (T)this.transactionWrapper.apply(supplier, (Object)tenantDTO);
    }

    public <T> T byTenantDirectly(Supplier<T> executor, Long tenantId) {
        if (tenantId == null || TenantConstant.DEFAULT_TENANT_ID.longValue() == tenantId.longValue()) {
            return this.byDefaultDirectly(executor);
        }
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
        Assert.state((tenant != null ? 1 : 0) != 0, (String)("\u79df\u6237" + tenantId + "\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        return this.byTenantDirectly(executor, tenant);
    }

    public <T> T byTenantDirectly(Supplier<T> executor, String tenantCode) {
        if (CharSequenceUtil.isBlank((CharSequence)tenantCode)) {
            return this.byDefaultDirectly(executor);
        }
        SysTenantDTO tenant = this.tenantClientProvider.getTenantByCode(tenantCode);
        Assert.state((tenant != null ? 1 : 0) != 0, (String)("\u79df\u6237" + tenantCode + "\u4e0d\u5b58\u5728"), (Object[])new Object[0]);
        return this.byTenantDirectly(executor, tenant);
    }

    public <T> T byTenantUser(Supplier<T> supplier, SysUserDTO currentUser) {
        if (currentUser.getSysTenantVO() != null && currentUser.getSysTenantVO().getSysUserId().longValue() != currentUser.getId().longValue() && currentUser.getSysTenantVO().getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)currentUser);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenant(Supplier<T> supplier, SysUserDTO currentUser) {
        if (currentUser.getSysTenantVO() != null && currentUser.getSysTenantVO().getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)currentUser);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenantAuto(Supplier<T> supplier) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null && tenant.getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)tenant);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> void byAllTenant(Supplier<T> supplier) {
        List<SysTenantDTO> tenants = this.getAllTenant();
        for (SysTenantDTO tenant : tenants) {
            try {
                this.transactionWrapper.apply(supplier, (Object)tenant);
            }
            catch (Exception e) {
                logger.error("\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        try {
            this.transactionWrapper.apply(supplier, null);
        }
        catch (Exception e) {
            logger.error("\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private List<SysTenantDTO> getAllTenant() {
        return this.tenantClientProvider.getAllTenants();
    }

    private SysTenantDTO getTenant(Long sysTenantId) {
        return this.tenantClientProvider.getTenant(sysTenantId);
    }
}

