/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.support.CloudtInterceptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class TenantOrgRequestInterceptor
implements CloudtInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT.getLogger(TenantOrgRequestInterceptor.class);

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        Long tenantOrgId = this.obtainTenantOrgId(request);
        if (tenantOrgId != null) {
            TenantOrgContext.setTenantOrgId((Long)tenantOrgId);
        }
        return true;
    }

    public void afterCompletion(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, Exception ex) throws Exception {
        TenantOrgContext.cleaTenantOrgId();
    }

    private Long obtainTenantOrgId(HttpServletRequest request) {
        String tenantOrgId = request.getHeader("X-TenantOrg-Id");
        if (StringUtils.hasText((String)tenantOrgId)) {
            try {
                return Long.parseLong(tenantOrgId);
            }
            catch (NumberFormatException e) {
                logger.error("\u79df\u6237\u7ec4\u7ec7ID\u89e3\u6790\u5931\u8d25\uff1a{}", (Object)tenantOrgId, (Object)e);
            }
        }
        return null;
    }
}

