/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.flyway.common.FlywayBuilder;
import com.elitescloud.boot.flyway.common.FlywayHelper;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.tenant.client.common.TenantDatabaseRpcProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.context.util.database.SqlUtil;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@DubboService
@ResponseBody
@RequestMapping(value={"/rpc/tenant/client/db"}, produces={"application/json"})
public class TenantDatabaseRpcProviderImpl
implements TenantDatabaseRpcProvider {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT.getLogger(TenantDatabaseRpcProviderImpl.class);
    @Autowired(required=false)
    private FlywayBuilder flywayBuilder;
    @Autowired(required=false)
    private FlywayHelper flywayHelper;
    @Autowired(required=false)
    private TenantClientProperties tenantClientProperties;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public ApiResult<Boolean> schemaCreate(String schema) {
        if (!TenantClient.enabledTenant()) {
            logger.warn("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return ApiResult.ok((Object)true, (String)"\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
        }
        if (this.tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.NONE || this.tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.FIELD) {
            logger.warn("\u5f53\u524d\u7b56\u7565{}\u65e0\u9700\u521b\u5efaschema", (Object)this.tenantClientProperties.getIsolateStrategy());
            return ApiResult.ok((Object)true, (String)"\u5f53\u524d\u9694\u79bb\u7b56\u7565\u65e0\u9700\u521b\u5efa");
        }
        logger.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a{}", (Object)schema);
        try {
            this.flywayHelper.migrate(() -> this.flywayBuilder.createFlywayForTenant(AbstractTenantDatasourceProvider.getDefaultSchema(), schema));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u79df\u6237schema\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)e.getMessage());
        }
        logger.info("\u521b\u5efa\u65b0\u79df\u6237schema\uff1a\u3010{}\u3011\u6210\u529f\uff01", (Object)schema);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Boolean> schemaDrop(String schema) {
        if (!TenantClient.enabledTenant()) {
            logger.warn("\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
            return ApiResult.ok((Object)true, (String)"\u672a\u542f\u7528\u79df\u6237\u529f\u80fd");
        }
        if (this.tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.NONE || this.tenantClientProperties.getIsolateStrategy() == TenantIsolateStrategy.FIELD) {
            logger.warn("\u5f53\u524d\u7b56\u7565{}\u65e0\u9700\u5220\u9664", (Object)this.tenantClientProperties.getIsolateStrategy());
            return ApiResult.ok((Object)true, (String)"\u5f53\u524d\u9694\u79bb\u7b56\u7565\u65e0\u9700\u5220\u9664");
        }
        logger.info("\u5220\u9664\u79df\u6237schema\uff1a{}", (Object)schema);
        Database database = AbstractTenantDatasourceProvider.getDatabaseType();
        if (database == null) {
            return ApiResult.fail((String)"\u672a\u77e5\u6570\u636e\u5e93\u7c7b\u578b");
        }
        boolean result = this.dropSchema(database, this.normalizeSchemaName(schema));
        return ApiResult.ok((Object)result);
    }

    private String normalizeSchemaName(String schema) {
        Object prefix = AbstractTenantDatasourceProvider.getDefaultSchema();
        prefix = CharSequenceUtil.isBlank((CharSequence)prefix) ? "" : (String)prefix + "_";
        return (String)prefix + schema;
    }

    private boolean dropSchema(Database database, String schema) {
        try {
            boolean exists;
            String sql = SqlUtil.generateExistsSchemaSql((Database)database, (String)schema);
            boolean bl = exists = !this.jdbcTemplate.queryForList(sql).isEmpty();
            if (!exists) {
                logger.info("\u5220\u9664schema\u5931\u8d25\uff0cschema \u3010{}\u3011\u4e0d\u5b58\u5728", (Object)schema);
                return true;
            }
            sql = SqlUtil.generateDropSchemaSql((Database)database, (String)schema);
            int result = this.jdbcTemplate.update(sql);
            logger.info("\u5220\u9664schema\u3010{}\u3011\u7ed3\u679c\uff1a{}", (Object)schema, (Object)result);
            return true;
        }
        catch (Exception e) {
            logger.error("\u5220\u9664schema\u5931\u8d25\uff1a", (Throwable)e);
            return false;
        }
    }
}

