/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.database;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.db.meta.ColumnIndexInfo;
import cn.hutool.db.meta.IndexInfo;
import cn.hutool.db.meta.MetaUtil;
import cn.hutool.db.meta.Table;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.tenant.client.common.DataBaseExport;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractExporter {
    private static final Logger LOGGER = CloudtBootLoggerFactory.TENANT.getLogger(AbstractExporter.class);
    protected static final String PRIMARY_NAME = "PRIMARY";
    protected final DataBaseExport dataBaseExport;

    protected AbstractExporter(DataBaseExport dataBaseExport) {
        this.dataBaseExport = dataBaseExport;
    }

    public void export(Consumer<String> tableDdlConsumer) {
        this.checkParams();
        this.beforeExport();
        DataSource dataSource = this.buildDataSource();
        List<Table> metadataList = null;
        try {
            metadataList = this.queryMetadata(dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u8be2\u6570\u636e\u5e93\u8868\u7ed3\u6784\u5143\u6570\u636e\u5931\u8d25\uff1a", e);
        }
        if (CollectionUtils.isEmpty(metadataList)) {
            LOGGER.warn("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u8868\u7ed3\u6784");
            return;
        }
        this.write(metadataList, tableDdlConsumer);
    }

    protected abstract void beforeExport();

    protected abstract String generateTableDdl(Table var1);

    protected List<IndexInfo> distinctIndexInfo(Table table) {
        return table.getIndexInfoList().stream().collect(Collectors.groupingBy(t -> t.getColumnIndexInfoList().stream().map(ColumnIndexInfo::getColumnName).collect(Collectors.joining("_")), Collectors.collectingAndThen(Collectors.toList(), tt -> {
            Optional<IndexInfo> uniqueKey = tt.stream().filter(ttt -> !ttt.isNonUnique()).findAny();
            return uniqueKey.orElseGet(() -> (IndexInfo)tt.get(0));
        }))).values().stream().collect(Collectors.toList());
    }

    private String shortForName(String name) {
        return Arrays.stream(name.split("_")).map(t -> {
            if (!StringUtils.hasText((String)t)) {
                return t;
            }
            return t.charAt(0) + t.substring(t.length() - 1);
        }).collect(Collectors.joining());
    }

    protected String normalizeIndexName(IndexInfo indexInfo) {
        String prefix = CharSequenceUtil.equals((CharSequence)indexInfo.getIndexName().toUpperCase(), (CharSequence)PRIMARY_NAME) ? "pk_" : (indexInfo.isNonUnique() ? "idx_" : "udx_");
        return prefix + indexInfo.getTableName() + "_" + indexInfo.getColumnIndexInfoList().stream().map(ColumnIndexInfo::getColumnName).collect(Collectors.joining("_"));
    }

    private void write(List<Table> metadataList, Consumer<String> tableDdlConsumer) {
        for (Table table : metadataList) {
            tableDdlConsumer.accept(this.generateTableDdl(table));
        }
        LOGGER.info("\u5171{}\u8868\u5bfc\u51fa\u5b8c\u6bd5\uff01", (Object)metadataList.size());
    }

    private List<Table> queryMetadata(DataSource dataSource) {
        List tables = ArrayUtil.isEmpty((Object[])this.dataBaseExport.getTables()) ? MetaUtil.getTables((DataSource)dataSource) : Arrays.stream(this.dataBaseExport.getTables()).distinct().collect(Collectors.toList());
        if (tables.isEmpty()) {
            return Collections.emptyList();
        }
        return tables.stream().map(t -> MetaUtil.getTableMeta((DataSource)dataSource, (String)t)).collect(Collectors.toList());
    }

    private DataSource buildDataSource() {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(this.dataBaseExport.getJdbcUrl());
        dataSource.setUsername(this.dataBaseExport.getUsername());
        dataSource.setPassword(this.dataBaseExport.getPassword());
        dataSource.setDriverClassName(this.dataBaseExport.getDriverClassName());
        return dataSource;
    }

    private void checkParams() {
        Assert.hasText((String)this.dataBaseExport.getJdbcUrl(), (String)"jdbcUrl\u4e3a\u7a7a");
        Assert.hasText((String)this.dataBaseExport.getDriverClassName(), (String)"driverClassName\u4e3a\u7a7a");
        Assert.hasText((String)this.dataBaseExport.getUsername(), (String)"username\u4e3a\u7a7a");
        Assert.hasText((String)this.dataBaseExport.getPassword(), (String)"password\u4e3a\u7a7a");
        this.normalizeParam();
    }

    private void normalizeParam() {
        Object url = this.dataBaseExport.getJdbcUrl();
        if (!((String)url).contains("useInformationSchema")) {
            url = ((String)url).contains("?") ? (String)url + "&" : (String)url + "?";
            this.dataBaseExport.setJdbcUrl((String)url + "useInformationSchema = true");
        }
    }
}

