/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.context.TenantOrgContext;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.cloudt.core.tenant.support.TenantOrgDataIsolateProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DefaultTenantOrgDataIsolateProvider
implements TenantOrgDataIsolateProvider {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT_TRANSACTION.getLogger(DefaultTenantOrgDataIsolateProvider.class);
    private static final String TRANSACTION_NAME_PREFIX = "cloudt_tenantOrg";
    private final PlatformTransactionManager transactionManager;

    public DefaultTenantOrgDataIsolateProvider(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public <T> T byNoTenantOrg(@NotNull Supplier<T> supplier) {
        Boolean used = TenantOrgContext.isUseTenantOrg();
        if (used != null && !used.booleanValue()) {
            return supplier.get();
        }
        TenantOrgContext.setUseTenantOrg((boolean)false);
        String newTransactionName = this.generateTransactionName(null);
        if (logger.isDebugEnabled()) {
            logger.debug("Transaction execute\uff1a{} -> {}", (Object)TransactionSynchronizationManager.getCurrentTransactionName(), (Object)newTransactionName);
        }
        TransactionStatus transactionStatus = this.buildTenantTransactionDefinition(newTransactionName);
        try {
            T result = supplier.get();
            this.afterCompletion(transactionStatus, null);
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.afterCompletion(transactionStatus, e);
            throw ExceptionsUtil.wrapRuntime((Throwable)e);
        }
        finally {
            if (used == null) {
                TenantOrgContext.clearUseTenantOrg();
            } else {
                TenantOrgContext.setUseTenantOrg((boolean)true);
            }
        }
    }

    public <T> T byCurrentTenantOrg(@NotNull Supplier<T> supplier) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        return this.execute(supplier, currentUser == null ? null : currentUser.getTenantOrgId());
    }

    public <T> T byTenantOrg(@NotNull Supplier<T> supplier, @NotNull Long tenantOrgId) {
        return this.execute(supplier, tenantOrgId);
    }

    private <T> T execute(@NotNull Supplier<T> supplier, Long tenantOrgId) {
        Boolean used = TenantOrgContext.isUseTenantOrg();
        Long oldTenantOrgId = TenantOrgContext.getTenantOrg();
        if (used != null && !used.booleanValue()) {
            TenantOrgContext.setUseTenantOrg((boolean)true);
        }
        TenantOrgContext.setTenantOrgId((Long)tenantOrgId);
        String newTransactionName = this.generateTransactionName(null);
        if (logger.isDebugEnabled()) {
            logger.debug("Transaction execute\uff1a{} -> {}", (Object)TransactionSynchronizationManager.getCurrentTransactionName(), (Object)newTransactionName);
        }
        TransactionStatus transactionStatus = this.buildTenantTransactionDefinition(newTransactionName);
        try {
            T result = supplier.get();
            this.afterCompletion(transactionStatus, null);
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.afterCompletion(transactionStatus, e);
            throw ExceptionsUtil.wrapRuntime((Throwable)e);
        }
        finally {
            if (used == null) {
                TenantOrgContext.clearUseTenantOrg();
            } else {
                TenantOrgContext.setUseTenantOrg((boolean)used);
            }
            if (oldTenantOrgId == null) {
                TenantOrgContext.cleaTenantOrgId();
            } else {
                TenantOrgContext.setTenantOrgId((Long)oldTenantOrgId);
            }
        }
    }

    private String generateTransactionName(Long tenantOrgId) {
        return TRANSACTION_NAME_PREFIX + (String)(tenantOrgId == null ? "[default]" : "[" + tenantOrgId + "]");
    }

    private TransactionStatus buildTenantTransactionDefinition(String newTransactionName) {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        definition.setName(newTransactionName);
        return this.transactionManager.getTransaction((TransactionDefinition)definition);
    }

    private void afterCompletion(TransactionStatus transactionStatus, Exception exp) {
        if (transactionStatus == null || transactionStatus.isCompleted()) {
            return;
        }
        if (exp == null) {
            this.transactionManager.commit(transactionStatus);
            return;
        }
        this.transactionManager.rollback(transactionStatus);
        logger.warn("\u6267\u884c\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)exp);
    }
}

